/* Copyright (C) 2012 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _PROMPT_H_
#define _PROMPT_H_

#include <lualib.h>
#include <lauxlib.h>

void luap_setprompts(lua_State *L, const char *single, char *multi);
void luap_sethistory(lua_State *L, const char *file);
void luap_setname(lua_State *L, const char *name);
void luap_setcolor(lua_State *L, int enable);
void luap_enter(lua_State *L);
char *luap_describe (lua_State *L, int index);
int luap_call (lua_State *L, int n);

#endif
