/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.MPN;
import gnu.math.Numeric;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class IntNum
extends RatNum
implements Externalizable {
    public int ival;
    public int[] words;
    static final int minFixNum = -100;
    static final int maxFixNum = 1024;
    static final int numFixNum = 1125;
    static final IntNum[] smallFixNums = new IntNum[1125];

    static {
        int n = 1125;
        while (--n >= 0) {
            IntNum.smallFixNums[n] = new IntNum(n + -100);
        }
    }

    public IntNum() {
    }

    public IntNum(int n) {
        this.ival = n;
    }

    public static IntNum abs(IntNum intNum) {
        return intNum.isNegative() ? IntNum.neg(intNum) : intNum;
    }

    public static final IntNum add(int n, int n2) {
        return IntNum.make((long)n + (long)n2);
    }

    public static IntNum add(IntNum intNum, int n) {
        if (intNum.words == null) {
            return IntNum.add(intNum.ival, n);
        }
        IntNum intNum2 = new IntNum(0);
        intNum2.setAdd(intNum, n);
        return intNum2.canonicalize();
    }

    public static IntNum add(IntNum intNum, IntNum intNum2, int n) {
        IntNum intNum3;
        if (intNum.words == null && intNum2.words == null) {
            return IntNum.make((long)n * (long)intNum2.ival + (long)intNum.ival);
        }
        if (n != 1) {
            intNum2 = n == -1 ? IntNum.neg(intNum2) : IntNum.times(intNum2, IntNum.make(n));
        }
        if (intNum.words == null) {
            return IntNum.add(intNum2, intNum.ival);
        }
        if (intNum2.words == null) {
            return IntNum.add(intNum, intNum2.ival);
        }
        if (intNum2.ival > intNum.ival) {
            intNum3 = intNum;
            intNum = intNum2;
            intNum2 = intNum3;
        }
        intNum3 = IntNum.alloc(intNum.ival + 1);
        int n2 = intNum2.ival;
        long l = MPN.add_n(intNum3.words, intNum.words, intNum2.words, n2);
        long l2 = intNum2.words[n2 - 1] < 0 ? 0xFFFFFFFFL : 0L;
        while (n2 < intNum.ival) {
            intNum3.words[n2] = (int)(l += ((long)intNum.words[n2] & 0xFFFFFFFFL) + l2);
            l >>>= 32;
            ++n2;
        }
        if (intNum.words[n2 - 1] < 0) {
            --l2;
        }
        intNum3.words[n2] = (int)(l + l2);
        intNum3.ival = n2 + 1;
        return intNum3.canonicalize();
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof IntNum) {
            return IntNum.add(this, (IntNum)object2, n);
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public static IntNum alloc(int n) {
        if (n <= 1) {
            return new IntNum();
        }
        IntNum intNum = new IntNum();
        intNum.words = new int[n];
        return intNum;
    }

    public IntNum canonicalize() {
        if (this.words != null && (this.ival = IntNum.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            this.words = null;
        }
        if (this.words == null && this.ival >= -100 && this.ival <= 1024) {
            return smallFixNums[this.ival - -100];
        }
        return this;
    }

    boolean checkBits(int n) {
        if (n <= 0) {
            return false;
        }
        if (this.words == null) {
            return n > 31 || (this.ival & (1 << n) - 1) != 0;
        }
        int n2 = 0;
        while (n2 < n >> 5) {
            if (this.words[n2] != 0) {
                return true;
            }
            ++n2;
        }
        return (n & 0x1F) != 0 && (this.words[n2] & (1 << (n & 0x1F)) - 1) != 0;
    }

    public static int compare(IntNum intNum, IntNum intNum2) {
        int n;
        boolean bl;
        if (intNum.words == null && intNum2.words == null) {
            return intNum.ival < intNum2.ival ? -1 : (intNum.ival > intNum2.ival ? 1 : 0);
        }
        boolean bl2 = intNum.isNegative();
        if (bl2 != (bl = intNum2.isNegative())) {
            return bl2 ? -1 : 1;
        }
        int n2 = intNum.words == null ? 1 : intNum.ival;
        int n3 = n = intNum2.words == null ? 1 : intNum2.ival;
        if (n2 != n) {
            return n2 > n != bl2 ? 1 : -1;
        }
        return MPN.cmp(intNum.words, intNum2.words, n2);
    }

    public int compare(Object object2) {
        if (object2 instanceof IntNum) {
            return IntNum.compare(this, (IntNum)object2);
        }
        if (!(object2 instanceof RealNum)) {
            throw new IllegalArgumentException();
        }
        return ((RealNum)object2).compareReversed(this);
    }

    public final IntNum denominator() {
        return IntNum.one();
    }

    public Numeric div(Object object2) {
        if (object2 instanceof RatNum) {
            RatNum ratNum = (RatNum)object2;
            return RatNum.make(IntNum.times(this, ratNum.denominator()), ratNum.numerator());
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).divReversed(this);
    }

    public static void divide(long l, long l2, IntNum intNum, IntNum intNum2, int n) {
        boolean bl;
        boolean bl2;
        if (l < 0L) {
            bl2 = true;
            if (l == Long.MIN_VALUE) {
                IntNum.divide(IntNum.make(l), IntNum.make(l2), intNum, intNum2, n);
                return;
            }
            l = -l;
        } else {
            bl2 = false;
        }
        if (l2 < 0L) {
            bl = true;
            if (l2 == Long.MIN_VALUE) {
                if (n == 3) {
                    if (intNum != null) {
                        intNum.set(0);
                    }
                    if (intNum2 != null) {
                        intNum2.set(l);
                    }
                } else {
                    IntNum.divide(IntNum.make(l), IntNum.make(l2), intNum, intNum2, n);
                }
                return;
            }
            l2 = -l2;
        } else {
            bl = false;
        }
        long l3 = l / l2;
        long l4 = l % l2;
        boolean bl3 = bl2 ^ bl;
        boolean bl4 = false;
        if (l4 != 0L) {
            switch (n) {
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    bl4 = l4 > l2 - (l3 & 1L) >> 1;
                    break;
                }
            }
        }
        if (intNum != null) {
            if (bl4) {
                ++l3;
            }
            if (bl3) {
                l3 = -l3;
            }
            intNum.set(l3);
        }
        if (intNum2 != null) {
            if (bl4) {
                l4 = l2 - l4;
                bl2 ^= true;
            }
            if (bl2) {
                l4 = -l4;
            }
            intNum2.set(l4);
        }
    }

    public static void divide(IntNum intNum, IntNum intNum2, IntNum intNum3, IntNum intNum4, int n) {
        int n2;
        int n3;
        if (!(intNum.words != null && intNum.ival > 2 || intNum2.words != null && intNum2.ival > 2)) {
            long l = intNum.longValue();
            long l2 = intNum2.longValue();
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                IntNum.divide(l, l2, intNum3, intNum4, n);
                return;
            }
        }
        boolean bl = intNum.isNegative();
        boolean bl2 = intNum2.isNegative();
        boolean bl3 = bl ^ bl2;
        int n4 = intNum2.words == null ? 1 : intNum2.ival;
        int[] nArray = new int[n4];
        intNum2.getAbsolute(nArray);
        while (n4 > 1 && nArray[n4 - 1] == 0) {
            --n4;
        }
        int n5 = intNum.words == null ? 1 : intNum.ival;
        int[] nArray2 = new int[n5 + 2];
        intNum.getAbsolute(nArray2);
        while (n5 > 1 && nArray2[n5 - 1] == 0) {
            --n5;
        }
        int n6 = MPN.cmp(nArray2, n5, nArray, n4);
        if (n6 < 0) {
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n3 = n5;
            n2 = 1;
            nArray2[0] = 0;
        } else if (n6 == 0) {
            nArray2[0] = 1;
            n2 = 1;
            nArray[0] = 0;
            n3 = 1;
        } else if (n4 == 1) {
            n2 = n5;
            n3 = 1;
            nArray[0] = MPN.divmod_1(nArray2, nArray2, n5, nArray[0]);
        } else {
            int n7;
            int n8 = MPN.count_leading_zeros(nArray[n4 - 1]);
            if (n8 != 0) {
                MPN.lshift(nArray, 0, nArray, n4, n8);
                n7 = MPN.lshift(nArray2, 0, nArray2, n5, n8);
                nArray2[n5++] = n7;
            }
            if (n5 == n4) {
                nArray2[n5++] = 0;
            }
            MPN.divide(nArray2, n5, nArray, n4);
            n3 = n4;
            if (intNum4 != null || n != 3) {
                MPN.rshift0(nArray, nArray2, 0, n3, n8);
            }
            n2 = n5 + 1 - n4;
            if (intNum3 != null) {
                n7 = 0;
                while (n7 < n2) {
                    nArray2[n7] = nArray2[n7 + n4];
                    ++n7;
                }
            }
        }
        boolean bl4 = false;
        if (n3 > 1 || nArray[0] != 0) {
            switch (n) {
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    IntNum intNum5 = intNum4 == null ? new IntNum() : intNum4;
                    intNum5.set(nArray, n3);
                    intNum5 = IntNum.shift(intNum5, 1);
                    if (bl2) {
                        intNum5.setNegative();
                    }
                    int n9 = IntNum.compare(intNum5, intNum2);
                    if (bl2) {
                        n9 = -n9;
                    }
                    boolean bl5 = bl4 = n9 == 1 || n9 == 0 && (nArray2[0] & 1) != 0;
                }
            }
        }
        if (intNum3 != null) {
            intNum3.set(nArray2, n2);
            if (bl3) {
                if (bl4) {
                    intNum3.setInvert();
                } else {
                    intNum3.setNegative();
                }
            } else if (bl4) {
                intNum3.setAdd(1);
            }
        }
        if (intNum4 != null) {
            intNum4.set(nArray, n3);
            if (bl4) {
                IntNum intNum6;
                if (intNum2.words == null) {
                    intNum6 = intNum4;
                    intNum6.set(bl2 ? nArray[0] + intNum2.ival : nArray[0] - intNum2.ival);
                } else {
                    intNum6 = IntNum.add(intNum4, intNum2, bl2 ? 1 : -1);
                }
                if (bl) {
                    intNum4.setNegative(intNum6);
                } else {
                    intNum4.set(intNum6);
                }
            } else if (bl) {
                intNum4.setNegative();
            }
        }
    }

    public double doubleValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival <= 2) {
            return this.longValue();
        }
        if (this.isNegative()) {
            return IntNum.neg(this).roundToDouble(0, true, false);
        }
        return this.roundToDouble(0, false, false);
    }

    public static boolean equals(IntNum intNum, IntNum intNum2) {
        if (intNum.words == null && intNum2.words == null) {
            return intNum.ival == intNum2.ival;
        }
        if (intNum.words == null || intNum2.words == null || intNum.ival != intNum2.ival) {
            return false;
        }
        int n = intNum.ival;
        while (--n >= 0) {
            if (intNum.words[n] == intNum2.words[n]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof IntNum)) {
            return false;
        }
        return IntNum.equals(this, (IntNum)object2);
    }

    public void format(int n, StringBuffer stringBuffer) {
        if (this.words == null) {
            stringBuffer.append(Integer.toString(this.ival, n));
        } else if (this.ival <= 2) {
            stringBuffer.append(Long.toString(this.longValue(), n));
        } else {
            int[] nArray;
            boolean bl = this.isNegative();
            if (bl || n != 16) {
                nArray = new int[this.ival];
                this.getAbsolute(nArray);
            } else {
                nArray = this.words;
            }
            int n2 = this.ival;
            int n3 = n2 * (MPN.chars_per_word(n) + 1);
            if (n == 16) {
                if (bl) {
                    stringBuffer.append('-');
                }
                int n4 = stringBuffer.length();
                int n5 = n2;
                while (--n5 >= 0) {
                    int n6 = nArray[n5];
                    int n7 = 8;
                    while (--n7 >= 0) {
                        int n8 = n6 >> 4 * n7 & 0xF;
                        if (n8 <= 0 && stringBuffer.length() <= n4) continue;
                        stringBuffer.append(Character.forDigit(n8, 16));
                    }
                }
            } else {
                int n9;
                int n10 = stringBuffer.length();
                do {
                    n9 = MPN.divmod_1(nArray, nArray, n2, n);
                    stringBuffer.append(Character.forDigit(n9, n));
                    while (n2 > 0 && nArray[n2 - 1] == 0) {
                        --n2;
                    }
                } while (n2 != 0);
                if (bl) {
                    stringBuffer.append('-');
                }
                n9 = stringBuffer.length() - 1;
                while (n10 < n9) {
                    char c = stringBuffer.charAt(n10);
                    stringBuffer.setCharAt(n10, stringBuffer.charAt(n9));
                    stringBuffer.setCharAt(n9, c);
                    ++n10;
                    --n9;
                }
            }
        }
    }

    public static final int gcd(int n, int n2) {
        int n3;
        if (n2 > n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n2 != 0) {
            if (n2 == 1) {
                return n2;
            }
            n3 = n2;
            n2 = n % n2;
            n = n3;
        }
        return n;
    }

    public static IntNum gcd(IntNum intNum, IntNum intNum2) {
        int n = intNum.ival;
        int n2 = intNum2.ival;
        if (intNum.words == null) {
            if (n == 0) {
                return IntNum.abs(intNum2);
            }
            if (intNum2.words == null && n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                if (n < 0) {
                    n = -n;
                }
                if (n2 < 0) {
                    n2 = -n2;
                }
                return IntNum.make(IntNum.gcd(n, n2));
            }
            n = 1;
        }
        if (intNum2.words == null) {
            if (n2 == 0) {
                return IntNum.abs(intNum);
            }
            n2 = 1;
        }
        int n3 = (n > n2 ? n : n2) + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        intNum.getAbsolute(nArray);
        intNum2.getAbsolute(nArray2);
        n3 = MPN.gcd(nArray, nArray2, n3);
        IntNum intNum3 = new IntNum(0);
        intNum3.ival = n3;
        intNum3.words = nArray;
        return intNum3.canonicalize();
    }

    public void getAbsolute(int[] nArray) {
        int n;
        int n2;
        if (this.words == null) {
            n2 = 1;
            nArray[0] = this.ival;
        } else {
            n = n2 = this.ival;
            while (--n >= 0) {
                nArray[n] = this.words[n];
            }
        }
        if (nArray[n2 - 1] < 0) {
            IntNum.negate(nArray, nArray, n2);
        }
        n = nArray.length;
        while (--n > n2) {
            nArray[n] = 0;
        }
    }

    public int hashCode() {
        return this.words == null ? this.ival : this.words[0] + this.words[this.ival - 1];
    }

    public int intLength() {
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    public int intValue() {
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0];
    }

    public static int intValue(Object object2) {
        IntNum intNum = (IntNum)object2;
        if (intNum.words != null) {
            throw new ClassCastException("integer too large");
        }
        return intNum.ival;
    }

    public final boolean isMinusOne() {
        return this.words == null && this.ival == -1;
    }

    public final boolean isNegative() {
        return (this.words == null ? this.ival : this.words[this.ival - 1]) < 0;
    }

    public final boolean isOdd() {
        int n = this.words == null ? this.ival : this.words[0];
        return (n & 1) != 0;
    }

    public final boolean isOne() {
        return this.words == null && this.ival == 1;
    }

    public final boolean isZero() {
        return this.words == null && this.ival == 0;
    }

    public static IntNum lcm(IntNum intNum, IntNum intNum2) {
        if (intNum.isZero() || intNum2.isZero()) {
            return IntNum.zero();
        }
        intNum = IntNum.abs(intNum);
        intNum2 = IntNum.abs(intNum2);
        IntNum intNum3 = new IntNum();
        IntNum.divide(IntNum.times(intNum, intNum2), IntNum.gcd(intNum, intNum2), intNum3, null, 3);
        return intNum3.canonicalize();
    }

    public long longValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    public static IntNum make(int n) {
        if (n >= -100 && n <= 1024) {
            return smallFixNums[n - -100];
        }
        return new IntNum(n);
    }

    public static IntNum make(long l) {
        if (l >= -100L && l <= 1024L) {
            return smallFixNums[(int)l - -100];
        }
        int n = (int)l;
        if ((long)n == l) {
            return new IntNum(n);
        }
        IntNum intNum = IntNum.alloc(2);
        intNum.ival = 2;
        intNum.words[0] = n;
        intNum.words[1] = (int)(l >> 32);
        return intNum;
    }

    public static IntNum make(int[] nArray) {
        return IntNum.make(nArray, nArray.length);
    }

    public static IntNum make(int[] nArray, int n) {
        if (nArray == null) {
            return IntNum.make(n);
        }
        if ((n = IntNum.wordsNeeded(nArray, n)) <= 1) {
            return n == 0 ? IntNum.zero() : IntNum.make(nArray[0]);
        }
        IntNum intNum = new IntNum();
        intNum.words = nArray;
        intNum.ival = n;
        return intNum;
    }

    public static IntNum makeU(long l) {
        if (l >= 0L) {
            return IntNum.make(l);
        }
        IntNum intNum = IntNum.alloc(3);
        intNum.ival = 3;
        intNum.words[0] = (int)l;
        intNum.words[1] = (int)(l >> 32);
        intNum.words[2] = 0;
        return intNum;
    }

    public static IntNum minusOne() {
        return smallFixNums[99];
    }

    public static IntNum modulo(IntNum intNum, IntNum intNum2) {
        IntNum intNum3 = new IntNum();
        IntNum.divide(intNum, intNum2, null, intNum3, 1);
        return intNum3.canonicalize();
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof IntNum) {
            return IntNum.times(this, (IntNum)object2);
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric neg() {
        return IntNum.neg(this);
    }

    public static IntNum neg(IntNum intNum) {
        if (intNum.words == null && intNum.ival != Integer.MIN_VALUE) {
            return IntNum.make(-intNum.ival);
        }
        IntNum intNum2 = new IntNum(0);
        intNum2.setNegative(intNum);
        return intNum2.canonicalize();
    }

    public static boolean negate(int[] nArray, int[] nArray2, int n) {
        long l = 1L;
        boolean bl = nArray2[n - 1] < 0;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (int)(l += (long)(~nArray2[n2]) & 0xFFFFFFFFL);
            l >>= 32;
            ++n2;
        }
        return bl && nArray[n - 1] < 0;
    }

    public final IntNum numerator() {
        return this;
    }

    public static final IntNum one() {
        return smallFixNums[101];
    }

    public Numeric power(IntNum intNum) {
        if (this.isOne()) {
            return this;
        }
        if (this.isMinusOne()) {
            return intNum.isOdd() ? this : IntNum.one();
        }
        if (intNum.words == null && intNum.ival >= 0) {
            return IntNum.power(this, intNum.ival);
        }
        if (this.isZero()) {
            return intNum.isNegative() ? RatNum.infinity(-1) : this;
        }
        return super.power(intNum);
    }

    public static IntNum power(IntNum intNum, int n) {
        if (n <= 0) {
            if (n == 0) {
                return IntNum.one();
            }
            throw new Error("negative exponent");
        }
        if (intNum.isZero()) {
            return intNum;
        }
        int n2 = intNum.words == null ? 1 : intNum.ival;
        int n3 = (intNum.intLength() * n >> 5) + 2 * n2;
        boolean bl = intNum.isNegative() && (n & 1) != 0;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        intNum.getAbsolute(nArray);
        int n4 = 1;
        nArray2[0] = 1;
        block0: while (true) {
            int[] nArray4;
            if ((n & 1) != 0) {
                MPN.mul(nArray3, nArray, n2, nArray2, n4);
                nArray4 = nArray3;
                nArray3 = nArray2;
                nArray2 = nArray4;
                n4 += n2;
                while (nArray2[n4 - 1] == 0) {
                    --n4;
                }
            }
            if ((n >>= 1) == 0) break;
            MPN.mul(nArray3, nArray, n2, nArray, n2);
            nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
            n2 *= 2;
            while (true) {
                if (nArray[n2 - 1] != 0) continue block0;
                --n2;
            }
            break;
        }
        if (nArray2[n4 - 1] < 0) {
            ++n4;
        }
        if (bl) {
            IntNum.negate(nArray2, nArray2, n4);
        }
        return IntNum.make(nArray2, n4);
    }

    public static IntNum quotient(IntNum intNum, IntNum intNum2) {
        return IntNum.quotient(intNum, intNum2, 3);
    }

    public static IntNum quotient(IntNum intNum, IntNum intNum2, int n) {
        IntNum intNum3 = new IntNum();
        IntNum.divide(intNum, intNum2, intNum3, null, n);
        return intNum3.canonicalize();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (this.ival <= -1073741824) {
            if ((n &= Integer.MAX_VALUE) == 1) {
                n = objectInput.readInt();
            } else {
                int[] nArray = new int[n];
                int n2 = n;
                while (--n2 >= 0) {
                    nArray[n2] = objectInput.readInt();
                }
                this.words = nArray;
            }
        }
        this.ival = n;
    }

    public Object readResolve() throws ObjectStreamException {
        return this.canonicalize();
    }

    public void realloc(int n) {
        if (n == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < n || this.words.length > n + 2) {
            int[] nArray = new int[n];
            if (this.words == null) {
                nArray[0] = this.ival;
                this.ival = 1;
            } else {
                if (n < this.ival) {
                    this.ival = n;
                }
                System.arraycopy(this.words, 0, nArray, 0, this.ival);
            }
            this.words = nArray;
        }
    }

    public static IntNum remainder(IntNum intNum, IntNum intNum2) {
        IntNum intNum3 = new IntNum();
        IntNum.divide(intNum, intNum2, null, intNum3, 3);
        return intNum3.canonicalize();
    }

    public double roundToDouble(int n, boolean bl, boolean bl2) {
        int n2 = this.intLength();
        if ((n += n2 - 1) < -1075) {
            return bl ? -0.0 : 0.0;
        }
        if (n > 1023) {
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int n3 = n >= -1022 ? 53 : 53 + n + 1022;
        int n4 = n2 - (n3 + 1);
        long l = n4 > 0 ? (this.words == null ? (long)(this.ival >> n4) : MPN.rshift_long(this.words, this.ival, n4)) : this.longValue() << -n4;
        if (n == 1023 && l >> 1 == 0x1FFFFFFFFFFFFFL) {
            if (bl2 || this.checkBits(n2 - n3)) {
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return bl ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        if ((l & 1L) == 1L && ((l & 2L) == 2L || bl2 || this.checkBits(n4))) {
            if (((l += 2L) & 0x40000000000000L) != 0L) {
                ++n;
                l >>= 1;
            } else if (n3 == 52 && (l & 0x20000000000000L) != 0L) {
                ++n;
            }
        }
        long l2 = bl ? Long.MIN_VALUE : 0L;
        long l3 = (n += 1023) <= 0 ? 0L : (long)n << 52;
        long l4 = (l >>= 1) & 0xFFEFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2 | l3 | l4);
    }

    public final void set(int n) {
        this.words = null;
        this.ival = n;
    }

    public final void set(long l) {
        int n = (int)l;
        if ((long)n == l) {
            this.ival = n;
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = n;
            this.words[1] = (int)(l >> 32);
            this.ival = 2;
        }
    }

    public final void set(IntNum intNum) {
        if (intNum.words == null) {
            this.set(intNum.ival);
        } else if (this != intNum) {
            this.realloc(intNum.ival);
            System.arraycopy(intNum.words, 0, this.words, 0, intNum.ival);
            this.ival = intNum.ival;
        }
    }

    public final void set(int[] nArray, int n) {
        this.ival = n;
        this.words = nArray;
    }

    public final void setAdd(int n) {
        this.setAdd(this, n);
    }

    public void setAdd(IntNum intNum, int n) {
        if (intNum.words == null) {
            this.set((long)intNum.ival + (long)n);
            return;
        }
        int n2 = intNum.ival;
        this.realloc(n2 + 1);
        long l = n;
        int n3 = 0;
        while (n3 < n2) {
            this.words[n3] = (int)(l += (long)intNum.words[n3] & 0xFFFFFFFFL);
            l >>= 32;
            ++n3;
        }
        if (intNum.words[n2 - 1] < 0) {
            --l;
        }
        this.words[n2] = (int)l;
        this.ival = IntNum.wordsNeeded(this.words, n2 + 1);
    }

    void setInvert() {
        if (this.words == null) {
            this.ival ^= 0xFFFFFFFF;
        } else {
            int n = this.ival;
            while (--n >= 0) {
                this.words[n] = ~this.words[n];
            }
        }
    }

    public final void setNegative() {
        this.setNegative(this);
    }

    public void setNegative(IntNum intNum) {
        int n = intNum.ival;
        if (intNum.words == null) {
            if (n == Integer.MIN_VALUE) {
                this.set(-((long)n));
            } else {
                this.set(-n);
            }
            return;
        }
        this.realloc(n + 1);
        if (IntNum.negate(this.words, intNum.words, n)) {
            this.words[n++] = 0;
        }
        this.ival = n;
    }

    void setShift(IntNum intNum, int n) {
        if (n > 0) {
            this.setShiftLeft(intNum, n);
        } else {
            this.setShiftRight(intNum, -n);
        }
    }

    void setShiftLeft(IntNum intNum, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (intNum.words == null) {
            if (n < 32) {
                this.set((long)intNum.ival << n);
                return;
            }
            nArray = new int[]{intNum.ival};
            n3 = 1;
        } else {
            nArray = intNum.words;
            n3 = intNum.ival;
        }
        int n4 = n >> 5;
        int n5 = n3 + n4;
        if ((n &= 0x1F) == 0) {
            this.realloc(n5);
            n2 = n3;
            while (--n2 >= 0) {
                this.words[n2 + n4] = nArray[n2];
            }
        } else {
            this.realloc(++n5);
            n2 = MPN.lshift(this.words, n4, nArray, n3, n);
            n = 32 - n;
            this.words[n5 - 1] = n2 << n >> n;
        }
        this.ival = n5;
        n2 = n4;
        while (--n2 >= 0) {
            this.words[n2] = 0;
        }
    }

    void setShiftRight(IntNum intNum, int n) {
        if (intNum.words == null) {
            this.set(n < 32 ? intNum.ival >> n : (intNum.ival < 0 ? -1 : 0));
        } else if (n == 0) {
            this.set(intNum);
        } else {
            boolean bl = intNum.isNegative();
            int n2 = n >> 5;
            n &= 0x1F;
            int n3 = intNum.ival - n2;
            if (n3 <= 0) {
                this.set(bl ? -1 : 0);
            } else {
                if (this.words == null || this.words.length < n3) {
                    this.realloc(n3);
                }
                MPN.rshift0(this.words, intNum.words, n2, n3, n);
                this.ival = n3;
                if (bl) {
                    int n4 = this.ival - 1;
                    this.words[n4] = this.words[n4] | -1 << 32 - n;
                }
            }
        }
    }

    public static IntNum shift(IntNum intNum, int n) {
        if (intNum.words == null) {
            if (n <= 0) {
                return IntNum.make(n > -32 ? intNum.ival >> -n : (intNum.ival < 0 ? -1 : 0));
            }
            if (n < 32) {
                return IntNum.make((long)intNum.ival << n);
            }
        }
        if (n == 0) {
            return intNum;
        }
        IntNum intNum2 = new IntNum(0);
        intNum2.setShift(intNum, n);
        return intNum2.canonicalize();
    }

    public int sign() {
        int n;
        int n2 = n = this.words == null ? this.ival : this.words[this.ival - 1];
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    public static final IntNum ten() {
        return smallFixNums[110];
    }

    public static final IntNum times(int n, int n2) {
        return IntNum.make((long)n * (long)n2);
    }

    public static final IntNum times(IntNum intNum, int n) {
        boolean bl;
        if (n == 0) {
            return IntNum.zero();
        }
        if (n == 1) {
            return intNum;
        }
        int[] nArray = intNum.words;
        int n2 = intNum.ival;
        if (nArray == null) {
            return IntNum.make((long)n2 * (long)n);
        }
        IntNum intNum2 = IntNum.alloc(n2 + 1);
        if (nArray[n2 - 1] < 0) {
            bl = true;
            IntNum.negate(intNum2.words, nArray, n2);
            nArray = intNum2.words;
        } else {
            bl = false;
        }
        if (n < 0) {
            bl ^= true;
            n = -n;
        }
        intNum2.words[n2] = MPN.mul_1(intNum2.words, nArray, n2, n);
        intNum2.ival = n2 + 1;
        if (bl) {
            intNum2.setNegative();
        }
        return intNum2.canonicalize();
    }

    public static final IntNum times(IntNum intNum, IntNum intNum2) {
        Object object2;
        int[] nArray;
        int[] nArray2;
        if (intNum2.words == null) {
            return IntNum.times(intNum, intNum2.ival);
        }
        if (intNum.words == null) {
            return IntNum.times(intNum2, intNum.ival);
        }
        boolean bl = false;
        int n = intNum.ival;
        int n2 = intNum2.ival;
        if (intNum.isNegative()) {
            bl = true;
            nArray2 = new int[n];
            IntNum.negate(nArray2, intNum.words, n);
        } else {
            bl = false;
            nArray2 = intNum.words;
        }
        if (intNum2.isNegative()) {
            bl ^= true;
            nArray = new int[n2];
            IntNum.negate(nArray, intNum2.words, n2);
        } else {
            nArray = intNum2.words;
        }
        if (n < n2) {
            object2 = nArray2;
            nArray2 = nArray;
            nArray = object2;
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        object2 = IntNum.alloc(n + n2);
        MPN.mul(((IntNum)object2).words, nArray2, n, nArray, n2);
        ((IntNum)object2).ival = n + n2;
        if (bl) {
            ((IntNum)object2).setNegative();
        }
        return ((IntNum)object2).canonicalize();
    }

    public IntNum toExactInt(int n) {
        return this;
    }

    public RealNum toInt(int n) {
        return this;
    }

    public String toString(int n) {
        if (this.words == null) {
            return Integer.toString(this.ival, n);
        }
        if (this.ival <= 2) {
            return Long.toString(this.longValue(), n);
        }
        int n2 = this.ival * (MPN.chars_per_word(n) + 1);
        StringBuffer stringBuffer = new StringBuffer(n2);
        this.format(n, stringBuffer);
        return stringBuffer.toString();
    }

    public static IntNum valueOf(String string) throws NumberFormatException {
        return IntNum.valueOf(string, 10);
    }

    public static IntNum valueOf(String string, int n) throws NumberFormatException {
        int n2 = string.length();
        if (n2 <= 15 && n <= 16) {
            return IntNum.make(Long.parseLong(string, n));
        }
        int n3 = 0;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c == '-') {
                bl = true;
            } else if (c != '_' && (n3 != 0 || c != ' ' && c != '\t')) {
                int n5 = Character.digit(c, n);
                if (n5 < 0) break;
                byArray[n3++] = (byte)n5;
            }
            ++n4;
        }
        return IntNum.valueOf(byArray, n3, bl, n);
    }

    public static IntNum valueOf(byte[] byArray, int n, boolean bl, int n2) {
        int n3 = MPN.chars_per_word(n2);
        int[] nArray = new int[n / n3 + 1];
        int n4 = MPN.set_str(nArray, byArray, n, n2);
        if (n4 == 0) {
            return IntNum.zero();
        }
        if (nArray[n4 - 1] < 0) {
            nArray[n4++] = 0;
        }
        if (bl) {
            IntNum.negate(nArray, nArray, n4);
        }
        return IntNum.make(nArray, n4);
    }

    public static IntNum valueOf(char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        byte[] byArray = new byte[n2];
        int n5 = 0;
        while (n5 < n2) {
            char c = cArray[n + n5];
            if (c == '-') {
                bl = true;
            } else if (c != '_' && (n4 != 0 || c != ' ' && c != '\t')) {
                int n6 = Character.digit(c, n3);
                if (n6 < 0) break;
                byArray[n4++] = (byte)n6;
            }
            ++n5;
        }
        return IntNum.valueOf(byArray, n4, bl, n3);
    }

    /*
     * Unable to fully structure code
     */
    public static int wordsNeeded(int[] var0, int var1_1) {
        block3: {
            var2_2 = var1_1;
            if (var2_2 <= 0) break block3;
            if ((var3_3 = var0[--var2_2]) != -1) ** GOTO lbl11
            while (var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) < 0) {
                --var2_2;
                if (var3_3 == -1) {
                    continue;
                }
                break block3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl11:
                // 2 sources

                ** while (var3_3 == 0 && var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) >= 0)
            }
        }
        return var2_2 + 1;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = n = this.words == null ? 1 : IntNum.wordsNeeded(this.words, this.ival);
        if (n <= 1) {
            int n3;
            int n4 = this.words == null ? this.ival : (n3 = this.words.length == 0 ? 0 : this.words[0]);
            if (n3 >= -1073741824) {
                objectOutput.writeInt(n3);
            } else {
                objectOutput.writeInt(-2147483647);
                objectOutput.writeInt(n3);
            }
        } else {
            objectOutput.writeInt(Integer.MIN_VALUE | n);
            while (--n >= 0) {
                objectOutput.writeInt(this.words[n]);
            }
        }
    }

    public static final IntNum zero() {
        return smallFixNums[100];
    }
}

