// Swarm library. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <analysis/ActiveGraph.h>
#import <objectbase.h>
#import <activity.h> // getCurrentTime
#import <gui.h>
#import <defobj/DefObject.h> // getClass

// ActiveGraph: a graph that actively updates its own element when stepped.
@implementation ActiveGraph
PHASE(Creating)

- setElement: (id <GraphElement>)ge
{
  element = ge;
  return self;
}

- setDataFeed: d
{
  dataFeed = d;
  return self;
}

- createEnd
{
  if (element == nil || dataFeed == nil)
    [InvalidCombination raiseEvent: "ActiveGraph not initialized properly"];
  [self setProbedClass: getClass (dataFeed)];
  [super createEnd];
  return self;
}

PHASE(Setting)

PHASE(Using)

// add a new point, (currentTime, averageValue).
- (void)step
{
  [element addX: (double)getCurrentTime ()
           Y: [self doubleDynamicCallOn: dataFeed]];
}

@end
