/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.CatchClause;
import gnu.expr.ExitExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ObjectExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;

public class ExpFullWalker
extends ExpWalker {
    LambdaExp currentLambda = null;
    Object exitValue = null;

    public final LambdaExp getCurrentLambda() {
        return this.currentLambda;
    }

    public Object walkApplyExp(ApplyExp applyExp) {
        applyExp.func = (Expression)applyExp.func.walk(this);
        if (this.exitValue == null) {
            applyExp.args = this.walkExps(applyExp.args);
        }
        return applyExp;
    }

    public Object walkBeginExp(BeginExp beginExp) {
        beginExp.exps = this.walkExps(beginExp.exps);
        return beginExp;
    }

    public Object walkBlockExp(BlockExp blockExp) {
        blockExp.body = (Expression)blockExp.body.walk(this);
        if (this.exitValue == null && blockExp.exitBody != null) {
            blockExp.exitBody = (Expression)blockExp.exitBody.walk(this);
        }
        return blockExp;
    }

    public void walkDefaultArgs(LambdaExp lambdaExp) {
        if (lambdaExp.defaultArgs != null) {
            lambdaExp.defaultArgs = this.walkExps(lambdaExp.defaultArgs);
        }
    }

    public Object walkExitExp(ExitExp exitExp) {
        exitExp.result = (Expression)exitExp.result.walk(this);
        return exitExp;
    }

    public Object walkExpression(Expression expression) {
        return expression;
    }

    public Expression[] walkExps(Expression[] expressionArray) {
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n && this.exitValue == null) {
            expressionArray[n2] = (Expression)expressionArray[n2].walk(this);
            ++n2;
        }
        return expressionArray;
    }

    public Object walkIfExp(IfExp ifExp) {
        ifExp.test = (Expression)ifExp.test.walk(this);
        if (this.exitValue == null) {
            ifExp.then_clause = (Expression)ifExp.then_clause.walk(this);
        }
        if (this.exitValue == null) {
            ifExp.else_clause = (Expression)ifExp.else_clause.walk(this);
        }
        return ifExp;
    }

    public Object walkLambdaExp(LambdaExp lambdaExp) {
        LambdaExp lambdaExp2 = this.currentLambda;
        this.currentLambda = lambdaExp;
        try {
            Object[] objectArray;
            this.walkDefaultArgs(lambdaExp);
            if (this.exitValue == null && lambdaExp.body != null) {
                lambdaExp.body = (Expression)lambdaExp.body.walk(this);
            }
            if ((objectArray = lambdaExp.properties) != null) {
                int n = objectArray.length;
                int n2 = 1;
                while (n2 < n) {
                    Object object2 = objectArray[n2];
                    if (object2 instanceof Expression) {
                        objectArray[n2] = ((Expression)objectArray[n2]).walk(this);
                    }
                    n2 += 2;
                }
            }
            LambdaExp lambdaExp3 = lambdaExp;
            Object var5_8 = null;
            this.currentLambda = lambdaExp2;
            return lambdaExp3;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.currentLambda = lambdaExp2;
            throw throwable;
        }
    }

    public Object walkLetExp(LetExp letExp) {
        letExp.inits = this.walkExps(letExp.inits);
        if (this.exitValue == null) {
            letExp.body = (Expression)letExp.body.walk(this);
        }
        return letExp;
    }

    public Object walkObjectExp(ObjectExp objectExp) {
        LambdaExp lambdaExp = this.currentLambda;
        this.currentLambda = objectExp;
        try {
            LambdaExp lambdaExp2 = objectExp.firstChild;
            while (lambdaExp2 != null && this.exitValue == null) {
                this.walkLambdaExp(lambdaExp2);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
            ObjectExp objectExp2 = objectExp;
            Object var5_5 = null;
            this.currentLambda = lambdaExp;
            return objectExp2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.currentLambda = lambdaExp;
            throw throwable;
        }
    }

    public Object walkSetExp(SetExp setExp) {
        setExp.new_value = (Expression)setExp.new_value.walk(this);
        return setExp;
    }

    public Object walkSynchronizedExp(SynchronizedExp synchronizedExp) {
        synchronizedExp.object = (Expression)synchronizedExp.object.walk(this);
        if (this.exitValue == null) {
            synchronizedExp.body = (Expression)synchronizedExp.body.walk(this);
        }
        return synchronizedExp;
    }

    public Object walkTryExp(TryExp tryExp) {
        tryExp.try_clause = (Expression)tryExp.try_clause.walk(this);
        CatchClause catchClause = tryExp.catch_clauses;
        while (this.exitValue == null && catchClause != null) {
            catchClause.body = (Expression)catchClause.body.walk(this);
            catchClause = catchClause.getNext();
        }
        if (this.exitValue == null && tryExp.finally_clause != null) {
            tryExp.finally_clause = (Expression)tryExp.finally_clause.walk(this);
        }
        return tryExp;
    }
}

