/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.QuoteExp;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.lang.ELisp;
import gnu.jemacs.lang.ELispReader;
import gnu.jemacs.lang.ObArray;
import gnu.jemacs.lang.Symbol;
import gnu.jemacs.lang.UnwindProtect;
import gnu.jemacs.lang.While;
import gnu.jemacs.lang.defun;
import gnu.jemacs.lang.defvar;
import gnu.jemacs.lang.setq;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.util.FString;
import gnu.kawa.util.LList;
import gnu.mapping.Binding;
import gnu.mapping.BindingEnumeration;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.SFormat;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.text.Position;
import kawa.lang.Lambda;
import kawa.lang.SpecialType;
import kawa.lang.Syntax;
import kawa.standard.Scheme;
import kawa.standard.and_or;
import kawa.standard.begin;
import kawa.standard.eq_p;
import kawa.standard.equal_p;
import kawa.standard.ifp;
import kawa.standard.not;

public class CommonLisp
extends Interpreter {
    public static final LList FALSE = LList.Empty;
    public static final String TRUE = "t";
    public static final Expression nilExpr = new QuoteExp(FALSE);
    static boolean charIsInt = false;
    static CommonLisp instance;
    static int elispCounter;
    SpecialType booleanType;

    static {
        elispCounter = 0;
    }

    public CommonLisp() {
        Object object2;
        Named named;
        this.environ = new ObArray();
        this.environ.setName("interaction-environment." + ++elispCounter);
        Environment.setCurrent(this.environ);
        Scheme.getInstance();
        BindingEnumeration bindingEnumeration = Scheme.builtin().enumerateAllBindings();
        while (bindingEnumeration.hasMoreElements()) {
            named = bindingEnumeration.nextBinding();
            if (!((Binding)named).isBound()) continue;
            object2 = ((Procedure)named).getName();
            Object object3 = ((Binding)named).get();
            if (object3 instanceof Procedure || object3 instanceof Syntax) {
                this.defun((String)object2, object3);
                continue;
            }
            this.define((String)object2, object3);
        }
        if (instance == null) {
            instance = this;
        }
        try {
            CommonLisp.loadClass("kawa.lib.std_syntax", this.environ);
            CommonLisp.loadClass("kawa.lib.lists", this.environ);
            CommonLisp.loadClass("kawa.lib.strings", this.environ);
            CommonLisp.loadClass("gnu.jemacs.lang.SymbolOps", this.environ);
            CommonLisp.loadClass("gnu.jemacs.lang.NumberOps", this.environ);
            CommonLisp.loadClass("gnu.jemacs.lang.ArrayOps", this.environ);
            CommonLisp.loadClass("gnu.jemacs.lang.StringOps", this.environ);
            CommonLisp.loadClass("gnu.jemacs.lang.ListOps", this.environ);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.define(TRUE, TRUE);
        this.define("nil", "nil");
        named = new Lambda();
        ((Lambda)named).setKeywords("&optional", "&rest", "&key");
        ((Lambda)named).defaultDefault = nilExpr;
        this.defun("lambda", named);
        this.defun("defun", new defun((Lambda)named));
        this.defun("defvar", new defvar(false));
        this.defun("defconst", new defvar(true));
        this.defun("defsubst", new defun((Lambda)named));
        this.defun("setq", new setq());
        this.defun("progn", new begin());
        this.defun("if", new ifp());
        this.defun("or", new and_or(false, this));
        this.defun("and", new and_or(true, this));
        this.defun("while", new While());
        this.defun("unwind-protect", new UnwindProtect());
        object2 = new not(this);
        this.defun("not", object2);
        this.defun("null", object2);
        this.defun("eq", new eq_p(this));
        this.defun("equal", new equal_p(this));
        this.defun("typep", new InstanceOf(this));
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : (object2 instanceof gnu.kawa.util.Position ? ((gnu.kawa.util.Position)object2).getOffset() + 1 : -1);
        if (n < 0 || n > 65535) {
            throw new Signal("error", "not a character value");
        }
        return (char)n;
    }

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        if (object2 instanceof Position) {
            return IntNum.make(1 + ((Position)object2).getOffset());
        }
        return (Numeric)object2;
    }

    public Object booleanObject(boolean bl) {
        if (bl) {
            return TRUE;
        }
        return FALSE;
    }

    public static void defineAll(Object object2, Environment environment) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            String string = field.getName();
            if ((field.getModifiers() & 0x10) != 0) {
                try {
                    Object object3 = field.get(object2);
                    string = object3 instanceof Named ? ((Named)object3).getName() : (object3 instanceof Syntax ? ((Syntax)object3).getName() : string.intern());
                    if (object3 instanceof Binding) {
                        environment.addBinding((Binding)object3);
                        continue;
                    }
                    if (object3 instanceof Procedure || object3 instanceof Syntax) {
                        Symbol.setFunctionBinding(environment, string, object3);
                        continue;
                    }
                    environment.define(string, object3);
                    continue;
                }
                catch (Exception exception) {
                    throw new WrappedException("error accessing field " + field, exception);
                }
            }
            System.err.println("INTERNAL ERROR in ELisp.defineAll for " + string + " in " + clazz);
        }
    }

    private void defun(Procedure procedure) {
        this.defun(procedure.getName(), procedure);
    }

    protected void defun(String string, Object object2) {
        Named named;
        Symbol.setFunctionBinding(this.environ, string, object2);
        if (object2 instanceof Named && (named = (Named)object2).getName() == null) {
            named.setName(string);
        }
    }

    public void emitPushBoolean(boolean bl, CodeAttr codeAttr) {
        if (bl) {
            codeAttr.emitPushString(TRUE);
        } else {
            codeAttr.emitGetStatic(Compilation.scmListType.getDeclaredField("Empty"));
        }
    }

    public static Object getCharacter(int n) {
        if (charIsInt) {
            return IntNum.make(n);
        }
        return Char.make((char)n);
    }

    public static CommonLisp getInstance() {
        if (instance == null) {
            instance = new CommonLisp();
        }
        return instance;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new ELispReader(inPort, sourceMessages);
    }

    public String getName() {
        return "Emacs-Lisp";
    }

    public Environment getNewEnvironment() {
        return new ObArray(this.environ);
    }

    public static Object getString(Binding binding) {
        return CommonLisp.getString(binding.getName());
    }

    public static Object getString(String string) {
        return new FString(string);
    }

    public static Object getSymbol(String string) {
        if (string == "nil") {
            return FALSE;
        }
        return string;
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new SpecialType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public Type getTypeFor(String string) {
        if (string == TRUE) {
            string = "java.lang.Object";
        } else if (string == "marker") {
            string = "gnu.jemacs.buffer.Marker";
        } else if (string == "buffer") {
            string = "gnu.jemacs.buffer.Bufffer";
        } else if (string == "window") {
            string = "gnu.jemacs.buffer.Window";
        }
        return Scheme.string2Type(string);
    }

    public boolean hasSeparateFunctionNamespace() {
        return true;
    }

    public boolean isTrue(Object object2) {
        return object2 != FALSE;
    }

    public static void loadClass(String string, Environment environment) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            CommonLisp.defineAll(obj, environment);
            if (obj instanceof ModuleBody) {
                ((ModuleBody)obj).run();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            System.err.println("loadCklass:" + string);
            exception.printStackTrace(System.err);
            throw new WrappedException(exception);
        }
    }

    public Object noValue() {
        return FALSE;
    }

    public void print(Object object2, OutPort outPort) {
        if (object2 == Interpreter.voidObject) {
            return;
        }
        if (object2 instanceof Values) {
            Object[] objectArray = ((Values)object2).getValues();
            int n = 0;
            while (n < objectArray.length) {
                SFormat.print(objectArray[n], outPort);
                outPort.println();
                ++n;
            }
        } else {
            SFormat.print(object2, outPort);
            outPort.println();
        }
        outPort.flush();
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return ELispReader.readObject(inPort);
    }

    public static void registerEnvironment() {
        ELisp eLisp = new ELisp();
        Interpreter.defaultInterpreter = eLisp;
        Environment.setCurrent(eLisp.getEnvironment());
    }
}

