// Swarm library. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Objective C interface to Raster, for use with tclobjc.

#import <tkobjc/ArchivedGeometryWidget.h>
#import <gui.h>

// This could include a list of environments (graphics contexts).
@interface Raster: ArchivedGeometryWidget <Raster>
{
  id button1Client, button2Client, button3Client;
  SEL button1Sel, button2Sel, button3Sel;
  PixelValue *map;
@public
  id <Colormap> colormap;
  void *private;
  Color eraseColor;
  unsigned width, height;
}
+ createBegin: aZone;
- createEnd;
- setWidth: (unsigned)width;
- setHeight: (unsigned)height;
- setWidth: (unsigned)width Height: (unsigned)height;
- (id <Colormap>)getColormap;
- setColormap: (id <Colormap>)colormap;
- (void)drawPointX: (int)x Y: (int)y Color: (Color)c;
- (void)fillRectangleX0: (int)x0 Y0: (int)y0 X1: (int)x1 Y1: (int)y1 Color: (Color)c;
- (void)ellipseX0: (int)x0 Y0: (int)y0 X1: (int)x1 Y1: (int)y1 Width: (unsigned)width Color: (Color)c;
- (void)lineX0: (int)x0 Y0: (int)y0 X1: (int)x1 Y1: (int)y1 Width: (unsigned)width Color: (Color)c;
- (void)rectangleX0: (int)x0 Y0: (int)y0 X1: (int)x1 Y1: (int)y1 Width: (unsigned)width Color: (Color)c;
- (void)draw: (id <Drawer>)drawer X: (int)x Y: (int)y;
- (void)drawSelf;
- (void)erase;
- (void)handleButton: (int)n X: (int)x Y: (int)y;
- (void)setButton: (int)n Client: c Message: (SEL)s;
@end
