/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import java.io.PrintWriter;

public class CatchClause
extends ScopeExp {
    Expression body;
    CatchClause next;

    public CatchClause(String string, ClassType classType) {
        this.addDeclaration(string, classType);
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = this.firstDecl();
        Variable variable = declaration.allocateVariable(codeAttr);
        codeAttr.enterScope(this.scope);
        codeAttr.emitCatchStart(variable);
        this.body.compileWithPosition(compilation, target);
        codeAttr.emitCatchEnd();
        codeAttr.popScope();
    }

    public final Expression getBody() {
        return this.body;
    }

    public final CatchClause getNext() {
        return this.next;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(%catch ? ");
        this.body.print(printWriter);
        printWriter.print(")");
    }

    public final void setBody(Expression expression) {
        this.body = expression;
    }

    public final void setNext(CatchClause catchClause) {
        this.next = catchClause;
    }
}

