/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.ExceptionsAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;

public class Method
implements AttrContainer {
    private String name;
    Type[] arg_types;
    Type return_type;
    int access_flags;
    int name_index;
    int signature_index;
    Method next;
    ClassType classfile;
    Attribute attributes;
    ExceptionsAttr exceptions;
    CodeAttr code;
    private String signature;

    Method(ClassType clfile, int flags) {
        if (clfile.last_method == null) {
            clfile.methods = this;
        } else {
            clfile.last_method.next = this;
        }
        clfile.last_method = this;
        ++clfile.methods_count;
        this.access_flags = flags;
        this.classfile = clfile;
    }

    public void allocate_local(Variable local) {
        local.allocateLocal(this.code);
    }

    void assign_constants() {
        ConstantPool constants = this.getConstants();
        if (this.name_index == 0 && this.name != null) {
            this.name_index = constants.addUtf8((String)this.name).index;
        }
        if (this.signature_index == 0) {
            this.signature_index = constants.addUtf8((String)this.getSignature()).index;
        }
        Attribute.assignConstants(this, this.classfile);
    }

    public void compile_checkcast(Type type) {
        this.code.emitCheckcast(type);
    }

    public void compile_linenumber(int linenumber) {
        if (this.code == null) {
            this.code = new CodeAttr(this);
        }
        this.code.putLineNumber(linenumber);
    }

    public void compile_push_this() {
        this.code.emitPushThis();
    }

    public void compile_push_value(Variable var) {
        this.code.emitLoad(var);
    }

    public void compile_store_value(Variable var) {
        this.code.emitStore(var);
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final CodeAttr getCode() {
        return this.code;
    }

    public final ConstantPool getConstants() {
        return this.classfile.constants;
    }

    public ClassType getDeclaringClass() {
        return this.classfile;
    }

    public final ExceptionsAttr getExceptionAttr() {
        return this.exceptions;
    }

    public final ClassType[] getExceptions() {
        if (this.exceptions == null) {
            return null;
        }
        return this.exceptions.getExceptions();
    }

    public int getModifiers() {
        return this.access_flags;
    }

    public final String getName() {
        return this.name;
    }

    public final Method getNext() {
        return this.next;
    }

    public final Type[] getParameterTypes() {
        return this.arg_types;
    }

    public final Type getReturnType() {
        return this.return_type;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuffer buf = new StringBuffer(100);
            int args_count = this.arg_types.length;
            buf.append('(');
            int i = 0;
            while (i < args_count) {
                buf.append(this.arg_types[i].getSignature());
                ++i;
            }
            buf.append(')');
            buf.append(this.return_type.getSignature());
            this.signature = buf.toString();
        }
        return this.signature;
    }

    public final boolean getStaticFlag() {
        return (this.access_flags & 8) != 0;
    }

    public void initCode() {
        if (this.classfile.constants == null) {
            this.classfile.constants = new ConstantPool();
        }
        this.prepareCode(0);
        this.code.pushScope();
    }

    public void init_param_slots() {
        this.initCode();
        if ((this.access_flags & 8) == 0) {
            this.code.addLocal(this.classfile).setParameter(true);
        }
        int arg_count = this.arg_types.length;
        int i = 0;
        while (i < arg_count) {
            this.code.addLocal(this.arg_types[i]).setParameter(true);
            ++i;
        }
    }

    void instruction_start_hook(int max_size) {
        this.prepareCode(max_size);
    }

    void kill_local(Variable var) {
        var.freeLocal(this.code);
    }

    public void maybe_compile_checkcast(Type type) {
        Type stack_type = this.code.topType();
        if (type != stack_type) {
            this.code.emitCheckcast(type);
        }
    }

    public Scope popScope() {
        return this.code.popScope();
    }

    final Type pop_stack_type() {
        return this.code.popType();
    }

    void prepareCode(int max_size) {
        if (this.code == null) {
            this.code = new CodeAttr(this);
        }
        this.code.reserve(max_size);
    }

    public Scope pushScope() {
        this.prepareCode(0);
        return this.code.pushScope();
    }

    final void push_stack_type(Type type) {
        this.code.pushType(type);
    }

    public void push_var(Variable var) {
        this.code.emitLoad(var);
    }

    public boolean reachableHere() {
        return this.code.unreachable_here ^ true;
    }

    public final void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public void setExceptions(ClassType[] exn_types) {
        if (this.exceptions == null) {
            this.exceptions = new ExceptionsAttr(this);
        }
        this.exceptions.setExceptions(exn_types);
    }

    public void setExceptions(short[] exn_indices) {
        if (this.exceptions == null) {
            this.exceptions = new ExceptionsAttr(this);
        }
        this.exceptions.setExceptions(exn_indices, this.classfile);
    }

    public void setModifiers(int modifiers) {
        this.access_flags = modifiers;
    }

    public final void setName(int name_index) {
        if (name_index <= 0) {
            this.name = null;
        } else {
            CpoolUtf8 nameConstant = (CpoolUtf8)this.getConstants().getForced(name_index, 1);
            this.name = nameConstant.string;
        }
        this.name_index = name_index;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public void setSignature(int signature_index) {
        CpoolUtf8 sigConstant = (CpoolUtf8)this.getConstants().getForced(signature_index, 1);
        this.signature_index = signature_index;
        this.setSignature(sigConstant.string);
    }

    public void setSignature(String signature) {
        int len = signature.length();
        if (len < 3 || signature.charAt(0) != '(') {
            throw new ClassFormatError("bad method signature");
        }
        int pos = 1;
        Stack<Type> types = new Stack<Type>();
        while (true) {
            int arg_sig_len;
            if ((arg_sig_len = Type.signatureLength(signature, pos)) < 0) {
                if (pos < len && signature.charAt(pos) == ')') break;
                throw new ClassFormatError("bad method signature");
            }
            Type arg_type = Type.signatureToType(signature, pos, arg_sig_len);
            types.push(arg_type);
            pos += arg_sig_len;
        }
        this.arg_types = new Type[types.size()];
        int i = types.size();
        while (--i >= 0) {
            this.arg_types[i] = (Type)types.pop();
        }
        this.return_type = Type.signatureToType(signature, pos + 1, len - pos - 1);
    }

    public final void setStaticFlag(boolean is_static) {
        this.access_flags = is_static ? (this.access_flags |= 8) : (this.access_flags ^= 0xFFFFFFF7);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append(this.getDeclaringClass());
        sbuf.append(' ');
        sbuf.append(this.name);
        if (this.arg_types != null) {
            int args_count = this.arg_types.length;
            sbuf.append('(');
            int i = 0;
            while (i < args_count) {
                if (i > 0) {
                    sbuf.append(',');
                }
                sbuf.append(this.arg_types[i].getName());
                ++i;
            }
            sbuf.append(')');
            sbuf.append(this.return_type.getName());
        }
        return sbuf.toString();
    }

    void write(DataOutputStream dstr, ClassType classfile) throws IOException {
        dstr.writeShort(this.access_flags);
        dstr.writeShort(this.name_index);
        dstr.writeShort(this.signature_index);
        Attribute.writeAll(this, dstr);
    }
}

