/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.util.LList;
import gnu.kawa.util.PairWithPosition;
import gnu.kawa.util.Sequence;
import gnu.mapping.Binding;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrongArguments;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import kawa.lang.Translator;
import kawa.standard.Scheme;
import kawa.standard.load;

public class Shell {
    public static void run(Interpreter interpreter) {
        Shell.run(interpreter, interpreter.getEnvironment());
    }

    public static void run(Interpreter interpreter, Environment environment) {
        Binding binding;
        InPort inPort = InPort.inDefault();
        if (inPort instanceof TtyInPort && (binding = Environment.getCurrentBinding("default-prompter")) != null) {
            Procedure procedure = binding.getProcedure();
            ((TtyInPort)inPort).setPrompter(procedure);
        }
        Shell.run(interpreter, environment, inPort, OutPort.outDefault(), OutPort.errDefault());
    }

    public static void run(Interpreter interpreter, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        SourceMessages sourceMessages = new SourceMessages();
        Translator translator = new Translator(environment, sourceMessages);
        translator.immediate = true;
        Lexer lexer = interpreter.getLexer(inPort, sourceMessages);
        block5: while (true) {
            try {
                while (true) {
                    int n;
                    lexer.clearErrors();
                    PairWithPosition pairWithPosition = new PairWithPosition(inPort, null, (Object)LList.Empty);
                    Object object2 = ((LispReader)lexer).readObject();
                    while ((n = inPort.read()) >= 0 && n != 13 && n != 10) {
                        if (n == 32 || n == 9) continue;
                        inPort.unread();
                        break;
                    }
                    if (object2 == Sequence.eofValue) {
                        return;
                    }
                    pairWithPosition.car = object2;
                    ModuleExp moduleExp = Scheme.makeModuleExp(pairWithPosition, translator);
                    moduleExp.setName("atInteractiveLevel");
                    if (lexer.checkErrors(outPort2, 20)) continue block5;
                    Object object3 = moduleExp.evalModule(environment);
                    if (outPort == null) continue;
                    interpreter.print(object3, outPort);
                }
            }
            catch (WrongArguments wrongArguments) {
                if (wrongArguments.usage != null) {
                    outPort2.println("usage: " + wrongArguments.usage);
                }
                wrongArguments.printStackTrace(outPort2);
                continue;
            }
            catch (ClassCastException classCastException) {
                outPort2.println("Invalid parameter, was: " + classCastException.getMessage());
                classCastException.printStackTrace(outPort2);
                continue;
            }
            catch (SyntaxException syntaxException) {
                syntaxException.printAll(outPort2, 20);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(outPort2);
                continue;
            }
            break;
        }
    }

    public static void runFile(String string) {
        Environment environment = Environment.user();
        try {
            if (string.equals("-")) {
                load.loadSource(InPort.inDefault(), environment);
            } else {
                load.apply(string, environment);
            }
        }
        catch (SyntaxException syntaxException) {
            syntaxException.printAll(OutPort.errDefault(), 20);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open file " + string);
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void runString(String string, Interpreter interpreter, Environment environment) {
        Shell.run(interpreter, environment, new CharArrayInPort(string), null, OutPort.errDefault());
    }
}

