/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.kawa.util.Pair;
import gnu.kawa.util.Sequence;
import gnu.math.IntNum;
import gnu.text.CaseConvertFormat;
import gnu.text.Char;
import gnu.text.CompoundFormat;
import gnu.text.FlushFormat;
import gnu.text.IntegerFormat;
import gnu.text.LiteralFormat;
import gnu.text.ReportFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Stack;
import java.util.Vector;
import kawa.standard.LispCharacterFormat;
import kawa.standard.LispChoiceFormat;
import kawa.standard.LispEscapeFormat;
import kawa.standard.LispFreshlineFormat;
import kawa.standard.LispIterationFormat;
import kawa.standard.LispObjectFormat;
import kawa.standard.LispPluralFormat;
import kawa.standard.LispRealFormat;
import kawa.standard.LispRepositionFormat;
import kawa.standard.LispTabulateFormat;
import kawa.standard.ObjectFormat;

public class LispFormat
extends CompoundFormat {
    public static final String paramFromList = "<from list>";
    public static final String paramFromCount = "<from count>";
    public static final String paramUnspecified = "<unspecified>";

    public LispFormat(String string) throws ParseException {
        this(string.toCharArray());
    }

    public LispFormat(char[] cArray) throws ParseException {
        this(cArray, 0, cArray.length);
    }

    public LispFormat(char[] cArray, int n, int n2) throws ParseException {
        super(null, 0);
        int n3 = -1;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(100);
        Stack<Object> stack = new Stack<Object>();
        int n5 = n + n2;
        int n6 = n;
        block24: while (true) {
            Format format2;
            int n7;
            int n8;
            boolean bl;
            char c;
            if ((n6 >= n5 || cArray[n6] == '~') && stringBuffer.length() > 0) {
                stack.push(new LiteralFormat(stringBuffer));
                stringBuffer.setLength(0);
            }
            if (n6 >= n5) break;
            if ((c = cArray[n6++]) != '~') {
                stringBuffer.append(c);
                continue;
            }
            int n9 = stack.size();
            c = cArray[n6++];
            while (true) {
                if (c == '#') {
                    stack.push(paramFromCount);
                    c = cArray[n6++];
                } else if (c == 'v' || c == 'V') {
                    stack.push(paramFromList);
                    c = cArray[n6++];
                } else if (c == '-' || Character.digit(c, 10) >= 0) {
                    int n10;
                    boolean bl2 = bl = c == '-';
                    if (bl) {
                        c = cArray[n6++];
                    }
                    n8 = 0;
                    n7 = n6;
                    while ((n10 = Character.digit(c, 10)) >= 0) {
                        n8 = 10 * n8 + n10;
                        c = cArray[n6++];
                    }
                    stack.push(n6 - n7 < 8 ? IntNum.make(bl ? -n8 : n8) : IntNum.valueOf(cArray, n7, n6 - n7, 10, bl));
                } else if (c == '\'') {
                    stack.push(Char.make(cArray[n6++]));
                    c = cArray[n6++];
                } else {
                    if (c != ',') break;
                    stack.push(paramUnspecified);
                }
                if (c != ',') break;
                c = cArray[n6++];
            }
            bl = false;
            n8 = 0;
            while (true) {
                if (c == ':') {
                    bl = true;
                } else {
                    if (c != '@') break;
                    n8 = 1;
                }
                c = cArray[n6++];
            }
            c = Character.toUpperCase(c);
            n7 = stack.size() - n9;
            switch (c) {
                case 'B': 
                case 'D': 
                case 'O': 
                case 'R': 
                case 'X': {
                    int n11 = n9;
                    int n12 = c == 'R' ? LispFormat.getParam(stack, n11++) : (c == 'D' ? 10 : (c == 'O' ? 8 : (c == 'X' ? 16 : 2)));
                    int n13 = LispFormat.getParam(stack, n11);
                    int n14 = LispFormat.getParam(stack, n11 + 1);
                    int n15 = LispFormat.getParam(stack, n11 + 2);
                    int n16 = LispFormat.getParam(stack, n11 + 3);
                    int n17 = 0;
                    if (bl) {
                        n17 |= 1;
                    }
                    if (n8 != 0) {
                        n17 |= 2;
                    }
                    format2 = IntegerFormat.getInstance(n12, n13, n14, n15, n16, n17);
                    break;
                }
                case 'P': {
                    format2 = LispPluralFormat.getInstance(bl, n8 != 0);
                    break;
                }
                case '$': 
                case 'E': 
                case 'F': 
                case 'G': {
                    LispRealFormat lispRealFormat = new LispRealFormat();
                    lispRealFormat.op = c;
                    lispRealFormat.arg1 = LispFormat.getParam(stack, n9);
                    lispRealFormat.arg2 = LispFormat.getParam(stack, n9 + 1);
                    lispRealFormat.arg3 = LispFormat.getParam(stack, n9 + 2);
                    lispRealFormat.arg4 = LispFormat.getParam(stack, n9 + 3);
                    if (c != '$') {
                        lispRealFormat.arg5 = LispFormat.getParam(stack, n9 + 4);
                        if (c == 'E' || c == 'G') {
                            lispRealFormat.arg6 = LispFormat.getParam(stack, n9 + 5);
                            lispRealFormat.arg7 = LispFormat.getParam(stack, n9 + 6);
                        }
                    }
                    lispRealFormat.showPlus = n8;
                    lispRealFormat.internalPad = bl;
                    if (lispRealFormat.argsUsed == 0) {
                        format2 = lispRealFormat.resolve(null, 0);
                        break;
                    }
                    format2 = lispRealFormat;
                    break;
                }
                case 'A': 
                case 'S': {
                    format2 = ObjectFormat.getInstance(c == 'S');
                    if (n7 <= 0) break;
                    int n13 = LispFormat.getParam(stack, n9);
                    int n18 = LispFormat.getParam(stack, n9 + 1);
                    int n19 = LispFormat.getParam(stack, n9 + 2);
                    int n14 = LispFormat.getParam(stack, n9 + 3);
                    format2 = new LispObjectFormat((ReportFormat)format2, n13, n18, n19, n14, n8 != 0 ? 0 : 100);
                    break;
                }
                case 'C': {
                    int n20 = n7 > 0 ? LispFormat.getParam(stack, n9) : -1610612736;
                    format2 = LispCharacterFormat.getInstance(n20, 1, n8 != 0, bl);
                    break;
                }
                case '*': {
                    format2 = new LispRepositionFormat(LispFormat.getParam(stack, n9), bl, n8 != 0);
                    break;
                }
                case '(': {
                    c = bl ? (n8 != 0 ? (char)'U' : 'C') : (n8 != 0 ? (char)'T' : 'L');
                    CaseConvertFormat caseConvertFormat = new CaseConvertFormat(null, c);
                    stack.setSize(n9);
                    stack.push(caseConvertFormat);
                    stack.push(IntNum.make(n3));
                    n3 = n9;
                    continue block24;
                }
                case ')': {
                    if (n3 < 0 || !(stack.elementAt(n3) instanceof CaseConvertFormat)) {
                        throw new ParseException("saw ~) without matching ~(", n6);
                    }
                    CaseConvertFormat caseConvertFormat = (CaseConvertFormat)stack.elementAt(n3);
                    caseConvertFormat.setBaseFormat(LispFormat.popFormats(stack, n3 + 2, n9));
                    n3 = ((IntNum)stack.pop()).intValue();
                    continue block24;
                }
                case '?': {
                    LispIterationFormat lispIterationFormat = new LispIterationFormat();
                    lispIterationFormat.seenAt = n8;
                    lispIterationFormat.maxIterations = 1;
                    lispIterationFormat.atLeastOnce = true;
                    format2 = lispIterationFormat;
                    break;
                }
                case '{': {
                    LispIterationFormat lispIterationFormat = new LispIterationFormat();
                    lispIterationFormat.seenAt = n8;
                    lispIterationFormat.seenColon = bl;
                    lispIterationFormat.maxIterations = LispFormat.getParam(stack, n9);
                    stack.setSize(n9);
                    stack.push(lispIterationFormat);
                    stack.push(IntNum.make(n3));
                    n3 = n9;
                    continue block24;
                }
                case '}': {
                    if (n3 < 0 || !(stack.elementAt(n3) instanceof LispIterationFormat)) {
                        throw new ParseException("saw ~} without matching ~{", n6);
                    }
                    LispIterationFormat lispIterationFormat = (LispIterationFormat)stack.elementAt(n3);
                    lispIterationFormat.atLeastOnce = bl;
                    if (n9 > n3 + 2) {
                        lispIterationFormat.body = LispFormat.popFormats(stack, n3 + 2, n9);
                    }
                    n3 = ((IntNum)stack.pop()).intValue();
                    continue block24;
                }
                case '[': {
                    LispChoiceFormat lispChoiceFormat = new LispChoiceFormat();
                    lispChoiceFormat.param = LispFormat.getParam(stack, n9);
                    if (lispChoiceFormat.param == -1073741824) {
                        lispChoiceFormat.param = -1610612736;
                    }
                    if (bl) {
                        lispChoiceFormat.testBoolean = true;
                    }
                    if (n8 != 0) {
                        lispChoiceFormat.skipIfFalse = true;
                    }
                    stack.setSize(n9);
                    stack.push(lispChoiceFormat);
                    stack.push(IntNum.make(n3));
                    stack.push(IntNum.make(n4));
                    n3 = n9;
                    n4 = 0;
                    continue block24;
                }
                case ';': {
                    LispChoiceFormat lispChoiceFormat;
                    if (n3 >= 0 && stack.elementAt(n3) instanceof LispChoiceFormat) {
                        lispChoiceFormat = (LispChoiceFormat)stack.elementAt(n3);
                        if (bl) {
                            lispChoiceFormat.lastIsDefault = true;
                        }
                        Format format3 = LispFormat.popFormats(stack, n3 + 3 + n4, n9);
                        stack.push(format3);
                        ++n4;
                        continue block24;
                    }
                    throw new ParseException("saw ~; without matching ~[ or ~<", n6);
                }
                case ']': {
                    if (n3 < 0 || !(stack.elementAt(n3) instanceof LispChoiceFormat)) {
                        throw new ParseException("saw ~] without matching ~[", n6);
                    }
                    Format format4 = LispFormat.popFormats(stack, n3 + 3 + n4, n9);
                    stack.push(format4);
                    LispChoiceFormat lispChoiceFormat = (LispChoiceFormat)stack.elementAt(n3);
                    lispChoiceFormat.choices = LispFormat.getFormats(stack, n3 + 3, stack.size());
                    stack.setSize(n3 + 3);
                    n4 = ((IntNum)stack.pop()).intValue();
                    n3 = ((IntNum)stack.pop()).intValue();
                    continue block24;
                }
                case '^': {
                    int n21 = LispFormat.getParam(stack, n9);
                    int n22 = LispFormat.getParam(stack, n9 + 1);
                    int n23 = LispFormat.getParam(stack, n9 + 2);
                    format2 = new LispEscapeFormat(n21, n22, n23);
                    break;
                }
                case '\n': {
                    if (n8 != 0) {
                        stringBuffer.append(c);
                    }
                    if (bl) continue block24;
                    do {
                        if (n6 >= n5) continue block24;
                    } while (Character.isWhitespace(c = cArray[n6++]));
                    --n6;
                    continue block24;
                }
                case '!': {
                    format2 = FlushFormat.getInstance();
                    break;
                }
                case 'T': {
                    int n21 = LispFormat.getParam(stack, n9);
                    int n22 = LispFormat.getParam(stack, n9 + 1);
                    int n23 = LispFormat.getParam(stack, n9 + 2);
                    format2 = new LispTabulateFormat(n21, n22, n23, n8 != 0);
                    break;
                }
                case '&': {
                    int n21 = LispFormat.getParam(stack, n9);
                    format2 = new LispFreshlineFormat(n21);
                    break;
                }
                case '_': {
                    int n21 = LispFormat.getParam(stack, n9);
                    if (n21 == -1073741824) {
                        n21 = 1;
                    }
                    int n20 = bl && n8 != 0 ? 10 : 32;
                    format2 = LispCharacterFormat.getInstance(n20, n21, false, false);
                    break;
                }
                case '~': {
                    if (n7 == 0) {
                        stringBuffer.append(c);
                        continue block24;
                    }
                }
                case '%': 
                case '|': {
                    int n20;
                    int n24 = LispFormat.getParam(stack, n9);
                    if (n24 == -1073741824) {
                        n24 = 1;
                    }
                    if ((n20 = LispFormat.getParam(stack, n9 + 1)) == -1073741824) {
                        n20 = c == '|' ? 12 : (c == '%' ? 10 : 126);
                    }
                    format2 = LispCharacterFormat.getInstance(n20, n24, false, false);
                    break;
                }
                default: {
                    throw new ParseException("unrecognized format specifier ~" + c, n6);
                }
            }
            stack.setSize(n9);
            stack.push(format2);
        }
        if (n6 > n5) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 >= 0) {
            throw new ParseException("missing ~] or ~}", n6);
        }
        this.length = stack.size();
        this.formats = new Format[this.length];
        stack.copyInto(this.formats);
    }

    public static Object[] asArray(Object object2) {
        if (object2 instanceof Object[]) {
            return (Object[])object2;
        }
        if (!(object2 instanceof Sequence)) {
            return null;
        }
        int n = ((Sequence)object2).length();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (object2 instanceof Pair) {
            Pair pair = (Pair)object2;
            objectArray[n2++] = pair.car;
            object2 = pair.cdr;
        }
        if (n2 < n) {
            if (!(object2 instanceof Sequence)) {
                return null;
            }
            int n3 = n2;
            Sequence sequence = (Sequence)object2;
            while (n2 < n) {
                objectArray[n2] = sequence.elementAt(n3 + n2);
                ++n2;
            }
        }
        return objectArray;
    }

    static Format[] getFormats(Vector vector, int n, int n2) {
        Format[] formatArray = new Format[n2 - n];
        int n3 = n;
        while (n3 < n2) {
            formatArray[n3 - n] = (Format)vector.elementAt(n3);
            ++n3;
        }
        return formatArray;
    }

    public static int getParam(Vector vector, int n) {
        if (n >= vector.size()) {
            return -1073741824;
        }
        Object e = vector.elementAt(n);
        if (e == paramFromList) {
            return -1610612736;
        }
        if (e == paramFromCount) {
            return -1342177280;
        }
        if (e == paramUnspecified) {
            return -1073741824;
        }
        return ReportFormat.getParam(e, -1073741824);
    }

    static Format popFormats(Vector vector, int n, int n2) {
        Format format2 = n2 == n + 1 ? (Format)vector.elementAt(n) : new CompoundFormat(LispFormat.getFormats(vector, n, n2));
        vector.setSize(n);
        return format2;
    }
}

