/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleMethod;
import gnu.kawa.util.FString;
import gnu.kawa.util.FVector;
import gnu.kawa.util.LList;
import gnu.kawa.util.Pair;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.WrongType;
import gnu.math.IntNum;
import java.io.InputStream;
import java.util.StringTokenizer;
import kawa.lib.lists;
import kawa.lib.strings;
import kawa.lib.syntax;
import kawa.lib.vectors;
import kawa.standard.NumberCompare;
import kawa.standard.car;
import kawa.standard.cdr;
import kawa.standard.minus_oper;
import kawa.standard.plus_oper;

public class system
extends ModuleBody {
    static final system $instance = new system();
    public static final ModuleMethod makeProcess;
    public static final ModuleMethod openInputPipe;
    public static final ModuleMethod system;
    public static final ModuleMethod convertVectorToStringArray;
    public static final ModuleMethod convertListToStringArray;
    public static final ModuleMethod tokenizeStringToStringArray;
    public static final ModuleMethod tokenizeStringUsingShell;
    static Binding id0$isList;
    static Binding id1$commandParse;
    static final FString Lit0;
    static final IntNum Lit1;
    static final IntNum Lit2;

    /*
     * Enabled aggressive block sorting
     */
    static {
        Lit2 = IntNum.make(1);
        Lit1 = IntNum.make(0);
        Lit0 = new FString("invalid arguments to make-process");
        tokenizeStringUsingShell = new ModuleMethod($instance, 1, "tokenize-string-using-shell", 4097);
        tokenizeStringToStringArray = new ModuleMethod($instance, 2, "tokenize-string-to-string-array", 4097);
        convertListToStringArray = new ModuleMethod($instance, 3, "convert-list-to-string-array", 4097);
        convertVectorToStringArray = new ModuleMethod($instance, 4, "convert-vector-to-string-array", 4097);
        system = new ModuleMethod($instance, 5, "system", 4097);
        openInputPipe = new ModuleMethod($instance, 6, "open-input-pipe", 4097);
        makeProcess = new ModuleMethod($instance, 7, "make-process", 8194);
        Environment environment = Environment.getCurrent();
        id0$isList = environment.getBinding("list?");
        id1$commandParse = environment.getBinding("command-parse");
        Object object2 = Interpreter.voidObject;
    }

    public static Object makeProcess(Object args, Object env) {
        String[] stringArray;
        Runtime runtime;
        Object arargs = vectors.isVector(args) ? kawa.lib.system.convertVectorToStringArray(args) : (id0$isList.getProcedure().apply1(args) != Boolean.FALSE ? kawa.lib.system.convertListToStringArray(args) : (strings.isString(args) ? id1$commandParse.getProcedure().apply1(args) : (args instanceof String[] ? args : syntax.error$V(Lit0, LList.Empty))));
        Runtime runtime2 = Runtime.getRuntime();
        try {
            runtime = runtime2;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.lang.Runtime.exec(java.lang.String[],java.lang.String[])", 0);
        }
        try {
            stringArray = (String[])arargs;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.lang.Runtime.exec(java.lang.String[],java.lang.String[])", 1);
        }
        try {
            Process process = runtime.exec(stringArray, (String[])env);
            return process;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.lang.Runtime.exec(java.lang.String[],java.lang.String[])", 2);
        }
    }

    public static InputStream openInputPipe(Object command) {
        try {
            return ((Process)kawa.lib.system.makeProcess(command, null)).getInputStream();
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.lang.Process.getInputStream()", 0);
        }
    }

    public static int system(Object command) {
        try {
            return ((Process)kawa.lib.system.makeProcess(command, null)).waitFor();
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.lang.Process.waitFor()", 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object convertVectorToStringArray(Object vec) {
        IntNum count;
        try {
            count = IntNum.make(vectors.vectorLength((FVector)vec));
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "vector-length", 0);
        }
        String[] arr = new String[((Number)count).intValue()];
        Object i = Lit1;
        while (!NumberCompare.$Eq(i, count)) {
            FVector fVector;
            try {
                fVector = (FVector)vec;
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "vector-ref", 0);
            }
            try {
                arr[((Number)i).intValue()] = vectors.vectorRef(fVector, ((Number)i).intValue()).toString();
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "vector-ref", 1);
            }
            i = plus_oper.apply$V(new Object[]{i, Lit2});
        }
        return arr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object convertListToStringArray(Object lst) {
        IntNum count;
        try {
            count = IntNum.make(lists.length((LList)lst));
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "length", 0);
        }
        String[] arr = new String[((Number)count).intValue()];
        IntNum intNum = Lit1;
        Object p = lst;
        while (!lists.isNull(p)) {
            Object i;
            Object object2;
            try {
                arr[((Number)i).intValue()] = car.apply((Pair)p).toString();
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "car", 0);
            }
            try {
                object2 = cdr.apply((Pair)p);
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "cdr", 0);
            }
            i = plus_oper.apply$V(new Object[]{i, Lit2});
            p = object2;
        }
        return arr;
    }

    /*
     * Loose catch block
     */
    public static Object tokenizeStringToStringArray(Object string) {
        IntNum count;
        StringTokenizer toks = new StringTokenizer(string.toString());
        LList list = LList.Empty;
        while (true) {
            if (!toks.hasMoreTokens()) break;
            list = lists.cons(toks.nextToken(), list);
            continue;
            break;
        }
        LList rlist = list;
        try {
            count = IntNum.make(lists.length(rlist));
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "length", 0);
        }
        String[] arr = new String[((Number)count).intValue()];
        Object object2 = minus_oper.apply(count, Lit2);
        Object p = rlist;
        while (!lists.isNull(p)) {
            Object i;
            arr[((Number)i).intValue()] = car.apply((Pair)p).toString();
            Object object3 = cdr.apply((Pair)p);
            i = minus_oper.apply(i, Lit2);
            p = object3;
        }
        return arr;
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "cdr", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "car", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.util.StringTokenizer.nextToken()", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.util.StringTokenizer.hasMoreTokens()", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.util.StringTokenizer.<init>(java.lang.String)", 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String[] tokenizeStringUsingShell(Object string) {
        void var1_1;
        String[] arr = new String[]{"/bin/sh", "-c", string.toString()};
        return var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 1: {
                return kawa.lib.system.tokenizeStringUsingShell(object2);
            }
            case 2: {
                return kawa.lib.system.tokenizeStringToStringArray(object2);
            }
            case 3: {
                return kawa.lib.system.convertListToStringArray(object2);
            }
            case 4: {
                return kawa.lib.system.convertVectorToStringArray(object2);
            }
            case 5: {
                return IntNum.make(kawa.lib.system.system(object2));
            }
            case 6: {
                return kawa.lib.system.openInputPipe(object2);
            }
        }
        return super.apply1(moduleMethod, object2);
    }

    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        if (moduleMethod.selector == 7) {
            return kawa.lib.system.makeProcess(object2, object3);
        }
        return super.apply2(moduleMethod, object2, object3);
    }
}

