###--- >>> `influence.measures' <<<----- Regression Diagnostics

	## alias	 help(influence.measures)
	## alias	 help(print.infl)
	## alias	 help(summary.infl)
	## alias	 help(hat)
	## alias	 help(rstandard)
	## alias	 help(rstudent)
	## alias	 help(dfbetas)
	## alias	 help(dffits)
	## alias	 help(covratio)
	## alias	 help(cooks.distance)

##___ Examples ___:

## Analysis of the life-cycle savings data
## given in Belsley, Kuh and Welsch.
data(LifeCycleSavings)
lm.SR <- lm(sr ~ pop15 + pop75 + dpi + ddpi, data = LifeCycleSavings)
summary(inflm.SR <- influence.measures(lm.SR))
inflm.SR
which(apply(inflm.SR$is.inf, 1, any)) # which observations `are' influential
dim(dfb <- dfbetas(lm.SR))            # the 1st columns of influence.measures
all(dfb == inflm.SR$infmat[, 1:5])
rstandard(lm.SR)
rstudent(lm.SR)
dffits(lm.SR)
covratio(lm.SR)

## Huber's data [Atkinson 1985]
xh <- c(-4:0, 10)
yh <- c(2.48, .73, -.04, -1.44, -1.32, 0)
summary(lmH <- lm(yh ~ xh))
influence.measures(lmH)

## Keywords: 'regression'.


