###--- >>> `Special' <<<----- Special Functions of Mathematics

	## alias	 help(beta)
	## alias	 help(lbeta)
	## alias	 help(gamma)
	## alias	 help(lgamma)
	## alias	 help(digamma)
	## alias	 help(trigamma)
	## alias	 help(tetragamma)
	## alias	 help(pentagamma)
	## alias	 help(choose)
	## alias	 help(lchoose)

##___ Examples ___:

choose(5, 2)
for (n in 0:10) print(choose(n, k = 0:n))

curve(gamma(x),-3,4, n=1001, ylim=c(-10,100),
      col="red", lwd=2, main="gamma(x)")
abline(h=0,v=0, lty=3, col="midnightblue")

x <- seq(.1, 4, length = 201); dx <- diff(x)[1]
par(mfrow = c(2, 3))
for (ch in c("", "l","di","tri","tetra","penta")) {
  is.deriv <- nchar(ch) >= 2
  if (is.deriv) dy <- diff(y) / dx
  nm <- paste(ch, "gamma", sep = "")
  y <- get(nm)(x)
  plot(x, y, type = "l", main = nm, col = "red")
  abline(h = 0, col = "lightgray")
  if (is.deriv) lines(x[-1], dy, col = "blue", lty = 2)
}
par(mfrow = c(2, 2))

## Keywords: 'math'.


