###--- >>> `filter' <<<----- Linear Filtering on a Time Series

	## alias	 help(filter)

##___ Examples ___:

x <- 1:100
filter(x, rep(1, 3))
filter(x, rep(1, 3), sides = 1)
filter(x, rep(1, 3), sides = 1, circular = TRUE)
data(presidents)
filter(presidents, rep(1,3))

## A simple simulation function for ARMA processes
arma.sim <- function(n, ar = NULL, ma = NULL, sigma = 1.0)
{
    x <- ts(rnorm(n+100, 0, sigma), start = -99)
    if(length(ma)) x <- filter(x, c(1, ma), sides=1)
    if(length(ar)) x <- filter(x, ar, method = "recursive")
    as.ts(x[-(1:100)])
}
arma.sim(63, c(0.8897,-0.4858), c(-0.2279, 0.2488), sigma=sqrt(0.1796))

## Keywords: 'ts'.


