// Turmite.h							     TURMITES


// Turmite, a Swarm agent. This should inherit from a library FSM agent.


#import <objectbase.h>	       // we inherit swarm objects
#import <gui.h> // Raster
#import "TapeSpace.h"	       // we also have a Tape space object

// The definition of a Turmite object. We inherit code from the generic
// SwarmObject, which provides memory allocation and other niceties. It
// does not provide any sort of agent behaviour, though, that's up to us.

// First, Turmites have a lot of extra variables:

@interface Turmite: SwarmObject
{
  State state;			  	  // internal state
  int xpos, ypos;			  // my spatial coordinates
  State input, output;		  	  // read/write for tape square
  
  State *transitionTable;		  // my transition table
  int tapeXSize, tapeYSize;		  // how big the world is
  int offset, offset2;			  // basic offsets for table lookup
  int numStates;			  // number of states we have
  int numTapeStates;			  // number of states tape has
  int numMoves;				  // number of moves we can make

  TapeSpace *tape;			  // the tape for the world

  unsigned char nn, logt;	 	  // for log2 calculation
  
  int ii;				  // generic iteration variable
}

// these methods are used to initialize the object's state. First,
// methods that have to be sent to create an object.

-setTape: (TapeSpace *) t;			  // which tape are we in?

-setNumStates: (int) n; 			  // fix constant params
-setNumTapeStates: (int) t;
-setNumMoves: (int) m;

// As a convention, I put the -createEnd here to indicate that we're done
// defining new methods that are required before createEnd.

-createEnd;

// Other methods to set Turmite state. These can be called after the
// object has been fully created.

-setState: (State) s;		 // set mite's state

-setRandom;			 // set state, coordinates and t-table randomly


// The major Turmite behaviour: do one "time step" (all mite action).

-step;

// extra display code (Turmites currently draw themselves)

-drawSelfOn: (id <Raster>)r;

@end
