// TapeSpace.m							TURMITES

// implementation of TapeSpace - subclass initializeWorld of  Ca2d

// Does not use stepWorld of Ca2D, but it could.....
// Ca2d should inherit from a simple array holding state 
// and swapping new and old buffers....

#import "TapeSpace.h"

@implementation TapeSpace

// Initialize tape uniformly to 0 state

- initializeLattice
{
   int x, y;

   for (x = 0; x < xsize; x++)
     for (y = 0; y < ysize; y++)
       [self putValue: 0 atX: x Y: y];
   
   [self updateLattice];			// make this the "old" tape
   
   return self;
}

// must subclass stepWorld of Ca2d super-class....
// but don't want to do anything - should raise an error

- stepWorld
{
  return self;
}

// Methods to get dimensions of tape...

- (int)getSizeX
{
  return xsize;
}

- (int)getSizeY
{
  return ysize;
}

@end
