#import <simtoolsgui/GUISwarm.h>
#import <space.h>
#import <gui.h>

#import "ForestModelSwarm.h"
#import "Species.h"
#import "YoungForest.h"

@interface ForestObserverSwarm: GUISwarm
{
  int displayFrequency;
  int showSeedDistribution;
  int showPopulationGraph;

  int speciesNumber;
  id speciesList;

  id displayList;
  id rasterList;

  id displayActions;
  id displaySchedule;

  ForestModelSwarm *forestModelSwarm;

  id <Colormap> colormap;

  id <ZoomRaster> forestRaster;
  id <ZoomRaster> youngForestRaster;
  id <ZoomRaster> fireRaster;

  id popGraph, speciesGraph, entropyGraph;
  id speciesEntropy;

  id <Object2dDisplay> treeDisplay;
  id <Object2dDisplay> youngForestDisplay;
  id <Value2dDisplay> fireDisplay;
}

// Methods overriden to make the Swarm.
+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;
- showAgeLevel;
- showSpecies;
@end

