// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************
//
// in apps we have to prepare a XXXInterace.m file for each type of agent:
// in the accompanying ct-hayek application of bp-ct this file corresponds
// to the files ConsumerInterface.m and ProducerInterface.m
//
// **********************************

// SpecificInterface.m                                        

// +++++++ start
#import "SpecificInterface.h"
// +++++++ end

@implementation SpecificInterface

  // all data are considered here in their external metrics; all the job
  // of tranforming the external metrics to the internal one (useful for
  // a neural netowrk) and then to the external one again is done
  // automatically using the various matrixes, which are contained in objects
  // that respond to the ...asExternal... methods, which apply the internal
  // and external min-max intervals contained in the minmax matrix
                                                       
  // the following methods are strictly related to the meaning the problem
  // data to which we are applying our neural network have

  // so we have to modify them whenever we change the problem if we want
  // to display agent data or operate with them in a CT way

  // the following "get" methods link the external names (used by the model
  // builder as variables) to the inputs/outputs/targets of the neural
  // network, where they are identified by a position in the input, output,
  // target vectors

// +++++++ start
- (float)getL1
         // L1 is the first input (a logical value) of an Agent in the OrXor
         // internal rule system in the basic 'bp-ct' application
{
  int k;
  // in each "get" we access a different pattern, as in a loop,
  // restarting from the first at the end (we use here the remainder of
  // the integer quotient calculated below with the % or Mod operator);

  // the count is made by 0.5; being k an int variable, we have to call
  // twice the method to change pattern; this mechanism is requested by
  // the use of this kind of messages in Observer.m, where EZGraph instances
  // call twice this kind of method to graph and to send to file the value
  // of each input, output or target

  k = nL1;  // NB the 'x.5' value in nL1 is copied as 'x' in k (with 'x' any
            // int
  nL1+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                           withShift: 0];
  // withShift: 0 has the meaning of no shift, because minmax (row) position
  // matches perfectly dataVerificationMatrix (col) position
}

- (float)getL2
         // L2 is the second input (a logical value) of an Agent in the OrXor
         // internal rule system in the basic 'bp-ct' application
{
  int k;
  k = nL2;
  nL2+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                           withShift: 0];
}

- (float)getOR_out
         // OR_out is the first output of an Agent in the OrXor
         // internal rule system in the basic 'bp-ct' application
{
  int k;
  k = nOR_out;
  nOR_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
  // withShift: inputNodeNumber matches minmax (row)
  // position and outputVerificationMatrix (col) position
  // (we have to use it here in all "get" methods which are related to
  // outputs or targets)
}

- (float)getOR_target
         // OR_target is the first target of an Agent in the OrXor
         // internal rule system in the basic 'bp-ct' application
{
  int k;
  k = nOR_target;
  nOR_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
  // withShift: inputNodeNumber matches minmax (row)
  // position and targetVerificationMatrix (col) position
  // (we have to use it here in all "get" methods which are related to
  // outputs or targets)
}

- (float)getXOR_out
         // XOR_out is the second output of an Agent in the OrXor
         // internal rule system in the basic 'bp-ct' application
{
  int k;
  k = nXOR_out;
  nXOR_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getXOR_target
         // XOR_target is the second target of an Agent in the OrXor
         // internal rule system in the basic 'bp-ct' application
{
  int k;
  k = nXOR_target;
  nXOR_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}
// +++++++ end

- initialize 
{
  int i;
  int outputNodeNumber;
  outputNodeNumber=[myAgentDataWarehouse getOutputNodeNumber];

  // counter initialization (strictly related to our application)

// +++++++ start
  nL1=0; nL2=0; nOR_out=0; nOR_target=0; nXOR_out=0; nXOR_target=0;
// +++++++ end

  // the counter mechanism works in the following way
  // the Observer gets the values via one of the methods reported above;
  // the counter is increased twice a cycle (with a step of 0.5, giving 1),
  // because the Observer display widget (which is also reporting data
  // in a file) makes two calls to the method

  // the integer remainder obtained dividing the counter
  // by the number of the patterns, lays always between 0 and
  // patternNumberInVerificationSet-1

  // in the CT case the number of calls can be odd, due to the interface
  // calls used to build targets: in this case, anyway,
  // patternNumberInVerificationSet is equal to -1 and the result of
  // k % patternNumberInVerificationSet is always 0

  // the following lines are useful only in CT scheme if we look (iva get...)
  // for initial values in outputVerificationMatrix (initial values are
  // stored in dataTrainingMatrix via DataWarehouse createEnd method)

  for (i=0;i<outputNodeNumber;i++)
  [outputVerificationMatrix R:0 C: i setFrom:
                            [dataTrainingMatrix R:0 C: i+inputNodeNumber]];

  return self;
}


- setCT_Inputs
{    

  // preserving previuously generated data, in CT scheme
  // when abs(patternNumberInTrainingSet)>1 ;
  // if abs(patternNumberInTraingingSet)=1 'shift' returns without effects
  [dataTrainingMatrix shift];

  // inputs:
  // we have to provide inputs (the same) both to the
  // dataVerificationMatrix (used in the no-learning acting phase in CT)
  // and to the dataTrainingMatrix (used in learning phase)

  // the learning phase uses one or more patterns and may be repeated in
  // each step (see the HowToUseBp-Ct.txt in the bp-ct package)
  // we store the data always in dataTrainingMatrix last row; the shift
  // order done above assures that the line is free and previous data are
  // preserved
  
// +++++++ start
  // orxor internal inputs (here we have an example of internal
  // inputs and targets generation, but not a CT application; the use of CT is
  // introduced in the ct-hayek application)
  v1 = [uniformIntRand getIntegerWithMin: 0 withMax: 1];
  v2 = [uniformIntRand getIntegerWithMin: 0 withMax: 1];

  // the inputs for the neural network are derived here from the v1 and v2
  // values


  [dataVerificationMatrix R: 0     C: 0 setFrom: v1 asExternalValueUsing:
                                                  minmax withShift: 0];
  [dataVerificationMatrix R: 0     C: 1 setFrom: v2 asExternalValueUsing:
                                                  minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 0 setFrom: v1 asExternalValueUsing:
                                                  minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 1 setFrom: v2 asExternalValueUsing:
                                                  minmax withShift: 0];
// +++++++ end

  return self;
}

- setCT_Targets
{
  // NB. A general rule: IF WE NEED TO USE OTHER AGENTS OUTPUTS TO
  // GENERATE TARGETS WE MUST MANDATORYLY REFER TO OUTPUTS IN THE VERIFICATION
  // SET; we observe automatically this general rule if we build the getXXX
  // methods in interface objects as it is done in the introductory packages
  // bp-ct and ct-hayek, i.e. always getting inputs, outputs and targets
  // from the verification matrixes and - obviously - if we access values
  // only by means of those getXXX methods (addressed to other agents'
  // interfaces)


// +++++++ start
  // strictly local target production (this is not an application of a
  // CT scheme; see the ct-hayek example for an actual CT scheme
  // implementation)

  // here it is not necessary to check consistency with minmax values
  // being the targets directly generated with well behaving values
  or=0; xor=0;
  if (v1==1 || v2==1) or=1;
  if ((v1==1 && v2==0) || (v1==0 && v2==1)) xor=1;

  // targets

  [dataVerificationMatrix R: 0     C: 2 setFrom: or  asExternalValueUsing:
                                                  minmax withShift: 0];
  [dataVerificationMatrix R: 0     C: 3 setFrom: xor asExternalValueUsing:
                                                  minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 2 setFrom: or  asExternalValueUsing:
                                                  minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 3 setFrom: xor asExternalValueUsing:
                                                  minmax withShift: 0];
// +++++++ end

  return self;
}

@end
