// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************

// ModelSwarm.h

#import "BPCTAgent.h"
#import "BPCTRuleMaster.h"
#import "BPCTRuleMaker.h"
#import "MatrixMult.h"
#import "VectorTransFunc.h"
#import "TransFunc.h"
#import "DataWarehouse.h"
#import <objectbase/Swarm.h>
#import <collections.h>
#import <simtools.h>      // necessary to invoke ObjectLoader
                          // and to use, with the 1.3.1 v. of Swarm,
                          // the ListShuffler protocol
#import <objectbase.h>    // needed by <ProbeMap> in ModelSwarm.m
#import <activity.h>

// +++++++ start
#import "SpecificInterface.h" // related to the agents used in our simulation
// +++++++ end

@interface ModelSwarm: Swarm
{
  int

// +++++++ start
  agentNumber, inputNodeNumber, hiddenNodeNumber, outputNodeNumber,
  patternNumberInVerificationSet, patternNumberInTrainingSet,
// +++++++ end

  epochNumberInEachTrainingCycle, epochGroups;
  BPCTRuleMaster * ruleMaster;
  BPCTRuleMaker * ruleMaker;

  MatrixMult * matrixMult;
  VectorTransFunc * vectorTransFunc;
  TransFunc * transFunc;

// +++++++ start
  id <List>  agentList;
//  id <ListShuffler> listShuffler;
  id <Array> agentArray;
  id <Index> agentArrayIndex;
// +++++++ end

  id <ActionGroup> modelActions;
  id <Schedule> modelSchedule;

  float weightRange, eps, alpha;
  int usingRandomOrderInLearning,
      longTermLearningInCT_OnlyWithCompleteTrainingSet,
      useOutputsAsTargetsInCT_RelearningScheme;

  int agentsAreDisplayingData, readWeightsFromFile;
  int useEO_EP;
}


+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

- (int) getPatternNumberInVerificationSet;
- (int) currentEpochGroups;
- (int) getCurrentEpochGroup;

// +++++++ start
- (int) getAgentNumber;
- getList;
- getAgentArrayIndex;
// +++++++ end

- openProbeTo: (int) ag;

@end
