// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// BPCTRuleMaster.m                                        

#import "BPCTRuleMaster.h"
#import <math.h>

@implementation BPCTRuleMaster

- createEnd
{
   [super createEnd];

   return self;                        
}

- setRuleMaker: rm
{
  ruleMaker=rm;
  return self;
}

- setMatrixMult: mM
{
  matrixMult=mM;
  return self;
}

- setVectorTransFunc: vts
{
  vectorTransFunc=vts;
  return self;
}

- applyRulesToInputOutputValuesInDataWarehouseStepA: agentDw

  // forward step in a neural network y=f(B f(Ax)) where x and y are vectors,
  // A and B are matrixes and f is a tranformation function, here the
  // logistic one r(s)=(1+e^(-k*s))^-1

  // when introducing a constant value (the bias) as input and hidden node
  // (neuron)
  //            y=f(B f(Ax)) becomes
  //            y=f(B (1, f(A (1,x')')' )' )

{
   int i, j;

  agentDataWarehouse=agentDw;

  // the ruleMaster operates with the data stored in the agentDataWarehouse;
  // here we get the address or the arrays containing data; technically we are
  // only moving information about pointers or about array dimensions
  dataVerificationMatrix   = [agentDataWarehouse getDataVerificationMatrix];
  outputVerificationMatrix = [agentDataWarehouse getOutputVerificationMatrix];
  targetVerificationMatrix = [agentDataWarehouse getTargetVerificationMatrix];
  minmax=[agentDataWarehouse getMinmax];
  inputNodeNumber  = [agentDataWarehouse getInputNodeNumber];
  inputNodeNumber1 = inputNodeNumber+1;
  hiddenNodeNumber = [agentDataWarehouse getHiddenNodeNumber];
  hiddenNodeNumber1= hiddenNodeNumber+1;
  outputNodeNumber = [agentDataWarehouse getOutputNodeNumber];
  patternNumberInVerificationSet = [agentDataWarehouse
                                         getPatternNumberInVerificationSet];

  if (patternNumberInVerificationSet < 0)
     patternNumberInVerificationSet *= -1; // dealing with CT case 
  
  wih = [agentDataWarehouse getWih];
  dwih= [agentDataWarehouse getDwih];
  who = [agentDataWarehouse getWho];
  dwho= [agentDataWarehouse getDwho];
  inputLayer  = [agentDataWarehouse getInputLayer];
  hiddenLayer = [agentDataWarehouse getHiddenLayer];
  outputLayer = [agentDataWarehouse getOutputLayer];

// errors
   backPropagationError=0;  // conventional back propagation error
   proportionalError=0;     // proportional error (my proposal)


// starting 'patternNumberInVerificationSet' cycles
   for (i=0;i<patternNumberInVerificationSet;i++)
{
   // we introduce a forward calculus in the neural network; if we refer to
   // the simplified form y=f(b f(A x)) we have ->

   // building inputLayer                       -> to set x
   [inputLayer P: 0 setFrom: 1.]; // constant artificial input (bias)
   for (j=0;j<inputNodeNumber;j++)
       [inputLayer P: j+1 setFrom: [dataVerificationMatrix R: i C: j]];

   // building hiddenLayer                     -> (A x)
   [matrixMult m1: wih m2: inputLayer  to1: hiddenLayer];

   // applying transformation function         -> f(A x)
   [vectorTransFunc from1: hiddenLayer to1: hiddenLayer];

   // hidden bias
   [hiddenLayer P: 0 setFrom: 1.];

   // building output layer                    -> B f(A x)
   [matrixMult m1: who m2: hiddenLayer to: outputLayer];

   // applying transformation function         -> f(B f(A x))
   [vectorTransFunc from: outputLayer to: outputLayer];


   // outputs and targets in each pattern
   for (j=0;j<outputNodeNumber;j++)
   {
   [outputVerificationMatrix R: i C: j setFrom: [outputLayer P: j] ];
   [targetVerificationMatrix R: i C: j setFrom:
                         [dataVerificationMatrix R: i C: j+inputNodeNumber] ];
   }

   // conventional back propagation error (sum of all the output units in
   // all the patterns, i.e. epoch error, divided by the number of patterns)
   // the error is also conventionally divided by 2

   for (j=0;j<outputNodeNumber;j++)
       backPropagationError+=pow([outputVerificationMatrix R: i C: j]-
                                 [targetVerificationMatrix R: i C: j],2)/
                                 (2*patternNumberInVerificationSet);

   // proportional error (arithmetic mean of all the output units in
   // all the patterns, i.e. epoch error)
   // this error is the ratio obtained dividing the abs value of
   // the difference of each target minus each output by one half of the
   // difference of the internal max value {i.e. [minmax R:3 C:j]} minus
   // the internal min value {i.e. [minmax R:2 C:j]} (the metrics is here
   // that of the internal values; anyway, when calculating a ratio the
   // metrics is not relevant)
   // we have  max error=2; min error=0

   for (j=0;j<outputNodeNumber;j++){
       proportionalError+=
          ( fabs([outputVerificationMatrix R: i C: j]
               - [targetVerificationMatrix R: i C: j]) /
               (([minmax R:j+inputNodeNumber C:3] -
                 [minmax R:j+inputNodeNumber C:2])/2.)
          ) / (outputNodeNumber*patternNumberInVerificationSet);  }
                   // the last quotient calculates the mean upon
                   // all patterns and output units

}
   return self;
}

- applyRulesToInputOutputValuesInDataWarehouseStepB: agentDw

{
  agentDataWarehouse=agentDw;

   // finally, we call the ruleMaker to learn from the trainingSet

   [ruleMaker adaptRulesToInputOutputValuesInDataWarehouse:
                                               agentDataWarehouse];

   return self;
}


-(float) getBackPropagationErrorInVerificationSet
{
  return backPropagationError;
}

-(float) getProportionalErrorInVerificationSet
{
  return proportionalError;
}

-(float) getBackPropagationErrorInTrainingSet
{
  return [ruleMaker getBackPropagationErrorInTrainingSet];
}

-(float) getProportionalErrorInTrainingSet
{
  return [ruleMaker getProportionalErrorInTrainingSet];
}

@end

