/*
 * $Id: st-stock.c,v 1.35.2.3 2004/07/25 17:47:24 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "art/add_bookmark.h"
#include "art/tune_in.h"
#include "art/record.h"
#include "art/browse.h"
#include "art/search.h"
#include "art/category.h"
#include "art/category_open.h"
#include "gettext.h"
#include "sgtk-stock.h"
#include "st-stock.h"

/*** constant definitions ****************************************************/

static const GtkStockItem items[] = {
  { ST_STOCK_TUNE_IN, N_("_Tune in"), 0, 0, NULL },
  { ST_STOCK_RECORD, N_("_Record"), 0, 0, NULL },
  { ST_STOCK_BROWSE, N_("_Browse"), 0, 0, NULL },
  { ST_STOCK_QUIT_WITHOUT_SAVING, N_("_Quit Without Saving"), 0, 0, NULL },
  { ST_STOCK_OPEN_LINK, N_("_Open Link"), 0, 0, NULL },
  { ST_STOCK_COPY_LINK_ADDRESS, N_("_Copy Link Address"), 0, 0, NULL },
  { ST_STOCK_NEW_PRESELECTION, N_("_New Preselection"), 0, 0, NULL },
  { ST_STOCK_ADD_BOOKMARK, N_("_Add Bookmark"), 0, 0, NULL }
};

/*** implementation **********************************************************/

void
st_stock_init (void)
{
  const sGtkStockIcon icons[] = {
    SGTK_STOCK_ICON_INLINE(ST_STOCK_TUNE_IN, art_tune_in),
    SGTK_STOCK_ICON_INLINE(ST_STOCK_RECORD, art_record),
    SGTK_STOCK_ICON_INLINE(ST_STOCK_BROWSE, art_browse),
    SGTK_STOCK_ICON_STOCK(ST_STOCK_QUIT_WITHOUT_SAVING, GTK_STOCK_QUIT),
    SGTK_STOCK_ICON_INLINE(ST_STOCK_SEARCH, art_search),
    SGTK_STOCK_ICON_STOCK(ST_STOCK_OPEN_LINK, GTK_STOCK_OPEN),
    SGTK_STOCK_ICON_STOCK(ST_STOCK_COPY_LINK_ADDRESS, GTK_STOCK_COPY),
    SGTK_STOCK_ICON_STOCK(ST_STOCK_NEW_PRESELECTION, GTK_STOCK_NEW),
    SGTK_STOCK_ICON_INLINE(ST_STOCK_ADD_BOOKMARK, art_add_bookmark),
    SGTK_STOCK_ICON_INLINE(ST_STOCK_CATEGORY, art_category),
    SGTK_STOCK_ICON_INLINE(ST_STOCK_CATEGORY_OPEN, art_category_open),
    SGTK_STOCK_ICON_END
  };
      
  sgtk_stock_register_icons(icons);
  gtk_stock_add_static(items, G_N_ELEMENTS(items));
}
