/*
 * $Id: sgtk-dialog.c,v 1.23 2004/03/08 08:29:56 jylefort Exp $
 *
 * Copyright (c) 2002, 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "sgtk-dialog.h"
#include "sgtk-hig.h"

/*** function declarations ***************************************************/

static void	sgtk_dialog_init	(sGtkDialog		*dialog);

/*** implementation **********************************************************/

GType
sgtk_dialog_get_type (void)
{
  static GType dialog_type = 0;
  
  if (! dialog_type)
    {
      static const GTypeInfo dialog_info = {
	sizeof(sGtkDialogClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(sGtkDialog),
	0,
	(GInstanceInitFunc) sgtk_dialog_init,
      };
      
      dialog_type = g_type_register_static(GTK_TYPE_DIALOG,
					   "sGtkDialog",
					   &dialog_info,
					   G_TYPE_FLAG_ABSTRACT);
    }

  return dialog_type;
}

static void
sgtk_dialog_init (sGtkDialog *dialog)
{
  int content_area_border;
  int action_area_border;

  /*
   * The kludgy calculations below are the consequence of
   * http://bugzilla.gnome.org/show_bug.cgi?id=98779
   */

  gtk_widget_style_get(GTK_WIDGET(dialog),
		       "content-area-border", &content_area_border,
		       "action-area-border", &action_area_border,
		       NULL);

  gtk_container_set_border_width(GTK_CONTAINER(dialog), SGTK_HIG_DIALOG_BORDER_WIDTH - content_area_border - action_area_border);
  gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
  gtk_dialog_set_has_separator(GTK_DIALOG(dialog), FALSE);
  gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(dialog)->vbox), SGTK_HIG_DIALOG_CONTENTS_SPACING - action_area_border - action_area_border);

  dialog->contents = gtk_event_box_new();
  gtk_container_set_border_width(GTK_CONTAINER(dialog->contents), action_area_border);
  gtk_widget_show(dialog->contents);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), dialog->contents, TRUE, TRUE, 0);
}
