! t_smp_pt.F90  2016jul09  wetherbee
! -----------------------------------------------------------------------
! This is free and unencumbered software released into the public domain.
!
! Anyone is free to copy, modify, publish, use, compile, sell, or 
! distribute this software, either in source code form or as a compiled 
! binary, for any purpose, commercial or non-commercial, and by any 
! means.
!
! In jurisdictions that recognize copyright laws, the author or authors 
! of this software dedicate any and all copyright interest in the 
! software to the public domain. We make this dedication for the benefit 
! of the public at large and to the detriment of our heirs and 
! successors. We intend this dedication to be an overt act of 
! relinquishment in perpetuity of all present and future rights to this 
! software under copyright law.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
! EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
! MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
! IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
! OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
! ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
! OTHER DEALINGS IN THE SOFTWARE.
!
! For more information, please refer to http://unlicense.org/
! ----------------------------------------------------------------------

! ---- desktop/smp: no openmp = serial
! gfortran  Srend.F90 -DSREND_NOMPI -DSREND_POINT_RADIUS_CLIP -O3 -c
! gfortran t_smp_pt.F90 Srend.o -O3 -o t_smp_pt
! ./t_smp_pt
! ---- desktop/smp: openmp
! gfortran  Srend.F90 -DSREND_NOMPI -DSREND_POINT_RADIUS_CLIP -fopenmp -O3 -c
! gfortran t_smp_pt.F90 Srend.o -fopenmp -O3 -o t_smp_pt
! ./t_smp_pt
! -----------------------------
!   NOTE: You can change the number of openmp threads from the default (usually
!   the number of CPU cores) by defining OMP_NUM_THREADS like this:
! export OMP_NUM_THREADS=4 
! ------------------------------
! DEBUG:
! gfortran: -lefence -fbacktrace  -fbounds-check -fcheck=all -g
! --------------------------------------------------------------------
! define these in Srend.F90 :
! #define SREND_NOMPI ! must be defined without MPI, or passed as -DSREND_NOMPI above
! #define SREND_POINT_RADIUS_CLIP ! must be defined, else passed as -DSREND_POINT_RADIUS_CLIP
! cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

! dimensions of N^3 cubical volume to create by formula
#define N 256


program t_smp_pt
#ifdef _OPENMP
      USE OMP_LIB
#endif
      USE srend

      IMPLICIT NONE

      character*1,dimension(:,:,:),allocatable :: fv ! data array of bytes
      character,save :: filenames*200                ! filenames parameter to pass
! -------------------------------------------------------------------- 
! loop variables in main program 
      integer tt
! for timing
      integer*8,save :: it1, it2, itc, total0, total1
      real*4,save :: rc
! flythrough parameters
      real*4 :: radius
! counters and vars for creating data
      integer*4 :: i,j,k
      real*4 :: x,y,z, cr
! target MPI ranks for compositing
      integer*4 :: xoff, yoff, zoff       ! xyz offsets for data
      integer*4 :: nx, ny, nz             ! xyz dimensions of data
      
! ccccccccc end variable declarations cccccccccccccccccccccccccccccccc

      call system_clock(it1,itc) ! start timer
      rc = 1.0 / itc             ! rc = 1/ticks_per_second

! width of block
      nx = N
      ny = N
      nz = N
      
! offsets for block
      xoff = 0
      yoff = 0
      zoff = 0
      
! allocate array for rendering, boundary of 1
      allocate( fv(1+xoff-1:xoff+nx+1,1+yoff-1:yoff+ny+1,1+zoff-1:zoff+nz+1) )
      print *,'fv size(fv)=',size(fv) ! debug

! create data: fv array of char*1, attempt to create interesting data for tests
      do k=zoff,zoff+nz+1
        z = 1. - (2.*k)/N
      do j=yoff,yoff+ny+1
        y = 1. - (2.*j)/N
      do i=xoff,xoff+nx+1
        x = 1. - (2.*i)/N
        cr = 4.0 + min(1.,1./(x*x+y*y+z*z + .1)**4)*(124.+124./3.*(sin(1./(x*y+.1))+ &
             cos(1./(x+y*z+.1))+sin(1.0/(z*x+y+.1))**2) )
        fv(i,j,k) = char(floor(cr))
      end do
      end do
      end do
      
! parameters for run

      call system_clock(it2)
      print *,'Prepped: span=',(it2-it1)*rc
      total0 = it2 ! starting time before compute loops, don't count prep time for this


! PPPPPPPPPPP parallel region PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP
! export OMP_NUM_THREADS=4 , or however many threads should be used here  
! NOTE: All threads render.
!$OMP PARALLEL default(shared) private(tt)

      do tt= 1,10
      
!$OMP MASTER
          print *,'start pass = ',tt
          call system_clock(it1)
          write(filenames,'("r_smp_pt/",I6.6,".jpg,")') tt  !pass number within: r/000001.ppm, trailing "," needed
          radius = 0.05 * tt      ! increase radius .05 to .5
!$OMP END MASTER
!$OMP BARRIER

          call srend_render(      &! rendering multiple blocks
          1,2,                    &! nV, nV_out
          N,                      &! Vdim
          (/0.5,0.5,1.5/),        &! Eye position
          (/0.0,0.0,-1.0/),       &! View vector
          (/0.0,1.0, 0.0/),       &! Up vector
          90.0, 90.0,             &! Alpha-horz, Beta-vert
          0.0,                    &! stereo: EyeRight
          -10.0,10.0,             &! x0,x1 -- clipping planes perpendicular to axes
          -10.0,10.0,             &! y0,y1
          -10.0,10.0,             &! z0,z1
          180.0,                  &! farpolar clip
          (/0.5,0.5,0.5/), radius,&! sphere clip: center and radius
          0.1, 10.0, 1,           &! near clip0,far clip1,nsh
          1,                      &! 0 spherical, 1 perspective
          0,                      &! 0=norm, 1=npole, 2=equator,3=spole
          0.25,                   &! sampling in cell units,(-)for out>in
          fv,                     &! data array
          nx,ny,nz,               &! XN,YN,ZN,Bd of data array passed in
          1,                      &! Bd
          xoff,yoff,zoff,         &! offset
          1024, 1024,             &! rendering Width, Height in pixels
          1,                      &! nR
          (/48/),                 &! cotab_offset(1:nR), test with 1 or 48
          filenames,              &! output file name(s)
          1,1,                    &! tiles right, tiles down: usually 1,1
          (/0/))                   ! target MPI rank, something to pass, not used for serial/smp

! sync threads between calls
!OMP BARRIER
          
!$OMP MASTER
          call system_clock(it2)
          print *,'Rendered: pass=',tt,' span=',(it2-it1)*rc
          it1 = it2     
!$OMP END MASTER

      end do ! tt pass loop
!$OMP END PARALLEL
! pppppppppp end parallel region ppppppppppppppppppppppppppppppppppppp
      
      call system_clock(it2)
      total1 = it2
      print *,'total runtime in calc loop =', (total1-total0)*rc

end program t_smp_pt ! program main



