! t_smp_orf4.F90
! -----------------------------------------------------------------------
! This is free and unencumbered software released into the public domain.
!
! Anyone is free to copy, modify, publish, use, compile, sell, or 
! distribute this software, either in source code form or as a compiled 
! binary, for any purpose, commercial or non-commercial, and by any 
! means.
!
! In jurisdictions that recognize copyright laws, the author or authors 
! of this software dedicate any and all copyright interest in the 
! software to the public domain. We make this dedication for the benefit 
! of the public at large and to the detriment of our heirs and 
! successors. We intend this dedication to be an overt act of 
! relinquishment in perpetuity of all present and future rights to this 
! software under copyright law.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
! EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
! MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
! IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
! OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
! ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
! OTHER DEALINGS IN THE SOFTWARE.
!
! For more information, please refer to http://unlicense.org/
! ----------------------------------------------------------------------

! --------------------------------------------------------------------
! ---- desktop/smp: no openmp = serial
! gfortran  Srend.F90 -DSREND_NOMPI -O3 -c
! gfortran t_smp_orf4.F90 Srend.o -O3 -o t_smp_orf4
! ./t_smp_orf4
! ---- desktop/smp: openmp
! gfortran  Srend.F90 -DSREND_NOMPI -fopenmp -O3 -c
! gfortran t_smp_orf4.F90 Srend.o -fopenmp -O3 -o t_smp_orf4
!     NOTE: export OMP_NUM_THREADS=4 (or whatever, so 1 thread per core if 4 cores)
! ./t_smp_orf4
! ------------------------------
! DEBUG:
! gfortran: -lefence -fbacktrace  -fbounds-check -fcheck=all -g
! --------------------------------------------------------------------
! define these in Srend.F90 :
! #define SREND_NOMPI ! must be defined, commented out for MPI
! cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

program t_smp_orf4
#ifdef _OPENMP
      USE OMP_LIB
#endif
      USE srend

      IMPLICIT NONE

! dimensions orf tornado data
#define XN 483
#define ZN 499
#define YN 278

      real*4,dimension(:,:,:),allocatable :: fv4
      character*1,dimension(:,:,:),allocatable :: fv
      character,save :: filenames*200
! -------------------------------------------------------------------- 
! loop variables in main program 
      integer tt
! for timing
      integer*8,save :: it1, it2, itc, total0, total1
      real*4,save :: rc
! flythrough parameter
      real*4, dimension(3),save :: E
! counters
      integer*4 :: i,j,k, ii
      real*4 :: x
! target MPI ranks for compositing
      real*4 :: maxdat, mindat
      integer*4 :: dat(0:255)
! ccccccccc end variable declarations cccccccccccccccccccccccccccccccc

      call system_clock(it1,itc) ! start timer
      rc = 1.0 / itc             ! rc = 1/ticks_per_second
      
! allocate array for rendering
      allocate( fv4(0:XN+1,0:ZN+1,0:YN+1) )
      print *,'fv4 size=',size(fv4)

! read data
      open(unit=10,status='unknown',file='zvort3',access='stream')
      read(10) fv4
      close(10)
      
! scan data
      maxdat = fv4(0,0,0); mindat = maxdat
      do j=0,YN+1
      do k=0,ZN+1
      do i=0,XN+1
        if( fv4(i,k,j) > maxdat) maxdat = fv4(i,k,j)
        if( fv4(i,k,j) < mindat) mindat = fv4(i,k,j)
      end do
      end do
      end do
      print *,'max =',maxdat, ' min =', mindat
!      STOP ! max about .0125, min 0

! scale to bytes, also shift y and z
      allocate( fv(0:XN+1,0:YN+1,0:ZN+1) )
      do k=0,ZN+1
      do j=0,YN+1
      do i=0,XN+1
!        x = fv4(i,k,j) / .0125 ! scale to within [0,1] ! for qc
!        x = fv4(i,k,j) / .06 ! scale to within [0,1] ! for qr
!        x = fv4(i,k,j) / 1.75 ! scale to within [0,1] ! for vortmag
!!        fv(i,j,k) = char( floor( 255.0 * x) ) ! scalar [0,1]
         x = fv4(i,k,j)
         if(x>=0.0) then
           x = x / (maxdat + .001)
         else
           x = -x / (mindat - .001)
         end if
         
         x = sign(1.0,x) * (x*x)**.25
         
         fv(i,j,k) = char( floor( 128.0 + 127.0 * x) ) ! zvort
      end do
      end do
      end do
      deallocate( fv4 )
      
! scan character values
      dat = 0 ! set all
      do k=0,ZN+1
      do j=0,YN+1
      do i=0,XN+1
        ii = ichar(fv(i,j,k))
        dat(ii) = dat(ii) + 1
      end do
      end do
      end do
! dump num values for each
      do i=0,255
        print *,'i=',i,' n=',dat(i)
      end do
!      STOP
      
! parameters for run
      E = (/0.5,0.0,1.5/)  ! initial eye position

      call system_clock(it2)
      print *,'Prepped: span=',(it2-it1)*rc
      total0 = it2 ! starting time before compute loops, don't count prep time for this


! PPPPPPPPPPP parallel region PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP
! export OMP_NUM_THREADS=4 , or however many threads should be used here  
! NOTE: All threads render.
!$OMP PARALLEL default(shared) private(tt)

      do tt= 1,11
      
!$OMP MASTER
          print *,'start pass = ',tt
          call system_clock(it1)
          write(filenames,'("r/",I6.6,".ppm,")') tt  !pass number within: r/000001.ppm, trailing "," needed
!$OMP END MASTER
!$OMP BARRIER

          call srend_render(      &! rendering multiple blocks
          1,2,                    &! nV, nV_out
          512,                    &! Vdim
          E,                      &! Eye position
          (/0.0,0.5,-1.0/),       &! View vector
          (/0.,1.,0./),           &! Up vector
          120.0, 60.0,            &! Alpha-horz, Beta-vert
          0.0,                    &! stereo: EyeRight
          -10.0,10.0,             &! x0,x1 -- clipping planes perpendicular to axes
          -10.0,10.0,             &! y0,y1
          -10.0,10.0,             &! z0,z1
          180.0,                  &! farpolar clip
          (/.5,.5,.5/),.5,        &! center(x,y,z) and radius of sphere to clip about 
          0.1, 10.0, 1,           &! near clip0,far clip1,nsh
          1,                      &! 0 spherical, 1 perspective
          0,                      &! 0=norm, 1=npole, 2=equator,3=spole
          0.25,                   &! sampling in cell units,(-)for out>in
          fv,                     &! data array
          XN,YN,ZN,               &! XN,YN,ZN,Bd,AMR of data array passed in
          1,                      &! Bd
          0,0,0,                  &! offset
          1024, 512,              &! rendering Width, Height in pixels
          1,                      &! nR
          (/80/),                 &! cotab_offset(1:nR), test with 1 or 48
          filenames,              &! output file name masks
          1,1,                    &! tiles right, tiles down: usually 1,1
          (/0/))                   ! target MPI rank        

! sync threads between calls
!OMP BARRIER
          
!$OMP MASTER
          call system_clock(it2)
          print *,'Rendered: pass=',tt,' span=',(it2-it1)*rc
          it1 = it2  
          
          E(3) = E(3) - .12      !move eye through volume 
!$OMP END MASTER

      end do ! tt pass loop
!$OMP END PARALLEL
! pppppppppp end parallel region ppppppppppppppppppppppppppppppppppppp
      
      call system_clock(it2)
      total1 = it2
      print *,'total runtime in calc loop =', (total1-total0)*rc

end program t_smp_orf4! program main



