/* Schedwi
   Copyright (C) 2007-2010 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_job.h -- jobs management functions */

#ifndef _SQL_JOB_H
#define _SQL_JOB_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_job_today OF((
		int workload_date,
		lwc_LL **rows,
		unsigned long long int parent_id,
		const char *cal_list,
		int start_time,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));

extern int sql_job_tomorrow OF((
		int workload_date,
		lwc_LL **rows,
		unsigned long long int parent_id,
		const char *cal_list,
		int start_time,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));

extern int sql_job_get_start_limit OF((
		int workload_date,
		lwc_LL *hierarchy_list,
		short int *start_limit,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));

extern int sql_job_get_max_duration OF((
		int workload_date,
		lwc_LL *hierarchy_list,
		short int *max_duration,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));

extern int sql_job_get_retries OF((
		int workload_date,
		lwc_LL *hierarchy_list,
		int *retries,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));

extern int sql_job_get_retries_interval OF((
		int workload_date,
		lwc_LL *hierarchy_list,
		short int *retries_interval,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));

extern int sql_job_set_start_limit OF((int workload_date,
				unsigned long long int job_id,
				long int start_limit,
				void (*error_func)(void *, const char *, int),
				void *user_data_error_func));

extern int sql_job_get_start_time OF((
		int workload_date,
		unsigned long long int job_id,
		int *start_time,
		void (*error_func)(void *, const char *, int),
		void *user_data_error_func));


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_job.h */

/*-----------------============== End Of File ==============-----------------*/
