/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* schedwi_jobtree_priv.h -- Private function to build the job/jobset tree */

#ifndef _SCHEDWI_JOBTREE_PRIV_H
#define _SCHEDWI_JOBTREE_PRIV_H

#include <schedwi.h>

#include <pthread.h>

#include <lwc_linkedlist.h>
#include <schedwi_time.h>
#include <schedwi_jobtree.h>
#include <calendar_list.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif


/* Element definition of the job/jobset arrays in the struct _jobtree (below)*/
struct _jobtree_jobs {
	unsigned long long int id;
	schedwi_jobtree_node_ptr node;
};
typedef struct _jobtree_jobs jobtree_jobs;
typedef struct _jobtree_jobs *jobtree_jobs_ptr;


/* Tree meta-informations */
struct _jobtree {
	/* Top jobset node */
	schedwi_jobtree_node_ptr top;

	/* Ordered array of all the job/jobsets in the tree */
	jobtree_jobs_ptr jobs;

	/* Number of jobs in the tree */
	unsigned int nb_jobs;

	/* Date */
	schedwi_date date;

	/* Mutex to access to the tree */
	pthread_mutex_t mutex;
};
typedef struct _jobtree jobtree;
typedef struct _jobtree *jobtree_ptr;


extern schedwi_jobtree_node_ptr jobtree_find OF((jobtree_ptr tree,
					    unsigned long long int id));
extern jobtree_ptr new_jobtree OF((	schedwi_date date,
					calendar_list_t_ptr calendars));
extern void free_jobtree OF((jobtree_ptr ptr));
extern int schedwi_jobtree_is_completed OF((jobtree_ptr ptr));
extern int schedwi_jobtree_run OF((	jobtree_ptr ptr,
					schedwi_time current_time));
extern int schedwi_jobtree_job_finished OF((jobtree_ptr ptr,
					unsigned long long int id,
					job_status_state status,
					long int duration,
					const char *status_message));
extern void schedwi_jobtree_print OF((jobtree_ptr ptr));
extern void schedwi_jobtree_adjust OF((	jobtree_ptr ptr, int drift,
					schedwi_time current_time));
extern void schedwi_jobtree_job_foreach OF((
				jobtree_ptr ptr,
				unsigned long long int id,
				int (*foreach_func)(schedwi_jobtree_node_ptr,
							void *),
				void *data_user));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* schedwi_jobtree_priv.h */

/*-----------------============== End Of File ==============-----------------*/
