/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* schedwi.h -- global definitions used by all sources files */

#ifndef _SCHEDWI_H
#define _SCHEDWI_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef OF /* function prototypes */
#  if PROTOTYPES
#    define OF(args)  args
#  else
#    define OF(args)  ()
#  endif
#endif

#if defined ENABLE_NLS && defined HAVE_GETTEXT
#  define _(string) gettext (string)
#  ifdef HAVE_LIBINTL_H
#    include <libintl.h>
#  endif
#else  /* not ENABLE_NLS && HAVE_GETTEXT */
#  define _(string) string
#endif /* not ENABLE_NLS && HAVE_GETTEXT */
#define N_(string) string

#ifndef HAVE_SIZE_T
typedef unsigned int size_t;
#endif

#ifndef HAVE_SSIZE_T
typedef int ssize_t;
#endif

#ifndef HAVE_TIME_T
typedef long int time_t;
#endif

#ifndef HAVE_SOCKLEN_T
typedef int socklen_t;
#endif

#endif /* _SCHEDWI_H */

/*------------------------======= End Of File =======------------------------*/
