/* Schedwi
   Copyright (C) 2011 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* reg_error_code.h -- Registration error codes */

#ifndef _REG_ERROR_CODE_H
#define _REG_ERROR_CODE_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	REG_OK,
	REG_SYSTEM_ERROR,
	REG_NO_CSR,
	REG_NOT_READY_YET,
	REG_CRT_PRESENT,
	REG_CSR_PRESENT,
	REG_ERROR_CSR	/* CSR no provided in the request from the agent */
} error_reason_t;

extern const char *reg_error_to_string OF((error_reason_t reason));
extern error_reason_t int_to_reg_err OF((int reason));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* reg_error_code.h */

/*-----------------============== End Of File ==============-----------------*/
