/* Work around the bug in some systems whereby lstat succeeds when
   given the zero-length file name argument.  The lstat from SunOS4.1.4
   has this bug.
   Copyright (C) 1997 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  */

/* written by Jim Meyering */

#if HAVE_CONFIG_H
#include <config.h>
#endif

/* Disable the definition of lstat to rpl_lstat (from config.h) in this
   file.  Otherwise, we'd get conflicting prototypes for rpl_lstat on
   most systems.  */
#undef lstat

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#if HAVE_ERRNO_H
#include <errno.h>
#endif
#ifndef errno
extern int errno;
#endif

/* FIXME: describe.  */

int
rpl_lstat (file, sbuf)
     const char *file;
     struct stat *sbuf;
{
  if (file && *file == 0)
    {
      errno = EINVAL;
      return -1;
    }

  return lstat (file, sbuf);
}
