# Schedwi
# Copyright (C) 2012, 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Links, constraint files, job stats and status tabsheet."""

from muntjac.api import TabSheet
from web.links import Links
from web.files import Files
from web.stats import Stats
from web.status import Status


class LinksAndFiles(TabSheet):

    """Links, constraint files, job stats and status tabsheet."""

    def __init__(self, jobTable, sql_session, workload=None):
        """Build the tabsheet UI.

        @param jobTable:
                    the L{web.jobtable.JobTable} associated object.
        @param sql_session:
                    SQLAlchemy session.
        @param workload:
                    workload to consider.
        """
        super(LinksAndFiles, self).__init__()
        self._sql_session = sql_session
        self._workload = workload
        self._c = jobTable

        t1 = Links(jobTable, sql_session, workload)
        t2 = Files(jobTable, sql_session, workload)
        t3 = Stats(jobTable, sql_session, workload)
        t4 = Status(jobTable, sql_session, workload)
        self.addTab(t1, _('Dependency Links'))
        self.addTab(t2, _('File Constraints'))
        self.addTab(t3, _('Statistics'))
        self.addTab(t4, _('Status'))
