# Schedwi
# Copyright (C) 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Auto-refresh the view regularly when the user is not using it."""

from muntjac.addon.refresher.refresher import Refresher
import parse_config

_refresher = None
_refresh_interval_in_millis = 1000 * parse_config.GUI_REFRESH


class AutoRefresh(object):

    """Set and control the auto-refresh interval."""

    def __init__(self, refresh_interval_in_seconds):
        """Initialize the object and start the refresher.

        @param refresh_interval_in_seconds:
                    refresh interval in seconds.
        """
        global _refresh_interval_in_millis, _refresher
        super(AutoRefresh, self).__init__()
        _refresh_interval_in_millis = refresh_interval_in_seconds * 1000
        _refresher = Refresher()
        _refresher.setRefreshInterval(_refresh_interval_in_millis)

    def get_refresher(self):
        """Return the internal L{muntjac.addon.refresher.refresher.Refresher}.

        @return:    the internal refresher object.
        @rtype:     L{muntjac.addon.refresher.refresher.Refresher}
        """
        global _refresher
        return _refresher

    def addListener(self, listener, iface=None):
        """Add a listener to the internal refresher.

        @param listener:  the listener to be added.
        @type listener:   L{muntjac.addon.refresher.refresher.RefreshListener}
        """
        global _refresher
        _refresher.addListener(listener, iface)

    @classmethod
    def reset(cls):
        """Re-initialize the counter.  This class method can for instance be
        called in the application callbacks to disable the refresh whilst
        the user is using the application.
        """
        global _refresher, _refresh_interval_in_millis
        if _refresher is not None:
            _refresher.setRefreshInterval(_refresh_interval_in_millis)
