# Schedwi
# Copyright (C) 2011-2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column
from sqlalchemy.types import Integer, Text, String
from sqlalchemy.orm import relation, backref

from base import Base, convert2unicode

from job_start_limit_s import job_start_limit_s
from job_max_duration_s import job_max_duration_s
from job_retries_s import job_retries_s
from job_retries_interval_s import job_retries_interval_s
from job_username_s import job_username_s
from job_file_out_s import job_file_out_s
from job_file_err_s import job_file_err_s
from job_control_group_s import job_control_group_s
from job_loadenv_s import job_loadenv_s
from job_success_return_code_s import job_success_return_code_s
from job_command_s import job_command_s
from job_arguments_s import job_arguments_s
from job_environment_s import job_environment_s
from job_host_s import job_host_s
from constraint_file_s import constraint_file_s
from link_s import link_s


class job_main_s(Base):
    __tablename__ = 'job_main_s'

    id = Column(Integer, primary_key=True)
    parent = Column(Integer)
    name = Column(String(255))
    rw_name = False
    type = Column(Integer)   # 0 (jobset) or 1 (job)
    rw_type = False
    enabled = Column(Integer)
    rw_enabled = False
    has_env = Column(Integer)
    rw_has_env = True
    description = Column(Text)
    rw_description = True
    x = Column(Integer)
    rw_x = True
    y = Column(Integer)
    rw_y = True
    cal_id = Column(Integer)
    rw_cal_id = False
    start_time = Column(Integer)
    rw_start_time = True
    workload_date = Column(Integer, primary_key=True)

    job_start_limit = relation(job_start_limit_s,
                               uselist=False,
                               backref="job_main_s",
                               cascade="all, delete, delete-orphan")
    rw_job_start_limit = True
    job_max_duration = relation(job_max_duration_s,
                                uselist=False,
                                backref="job_main_s",
                                cascade="all, delete, delete-orphan")
    rw_job_max_duration = True
    job_retries = relation(job_retries_s,
                           uselist=False,
                           backref="job_main_s",
                           cascade="all, delete, delete-orphan")
    rw_job_retries = True
    job_retries_interval = relation(job_retries_interval_s,
                                    uselist=False,
                                    backref="job_main_s",
                                    cascade="all, delete, delete-orphan")
    rw_job_retries_interval = True
    job_username = relation(job_username_s,
                            uselist=False,
                            backref="job_main_s",
                            cascade="all, delete, delete-orphan")
    rw_job_username = True
    job_file_out = relation(job_file_out_s,
                            uselist=False,
                            backref="job_main_s",
                            cascade="all, delete, delete-orphan")
    rw_job_file_out = True
    job_file_err = relation(job_file_err_s,
                            uselist=False,
                            backref="job_main_s",
                            cascade="all, delete, delete-orphan")
    rw_job_file_err = True
    job_control_group = relation(job_control_group_s,
                            uselist=False,
                            backref="job_main_s",
                            cascade="all, delete, delete-orphan")
    rw_job_control_group = True
    job_loadenv = relation(job_loadenv_s, uselist=False, backref="job_main_s",
                           cascade="all, delete, delete-orphan")
    rw_job_loadenv = True
    job_success_return_code = relation(job_success_return_code_s,
                                       uselist=False,
                                       backref="job_main_s",
                                       cascade="all, delete, delete-orphan")
    rw_job_success_return_code = True
    job_command = relation(job_command_s,
                           uselist=False,
                           backref="job_main_s",
                           cascade="all, delete, delete-orphan")
    rw_job_command = True
    job_arguments = relation(job_arguments_s,
                             order_by=job_arguments_s.position,
                             backref="job_main_s",
                             cascade="all, delete, delete-orphan")
    rw_job_arguments = True
    job_environment = relation(job_environment_s,
                               order_by=job_environment_s.position,
                               backref="job_main_s",
                               cascade="all, delete, delete-orphan")
    rw_job_environment = True
    job_host = relation(job_host_s, uselist=False, backref="job_main_s",
                        cascade="all, delete, delete-orphan")
    rw_job_host = True
    constraint_file = relation(constraint_file_s,
                               order_by=constraint_file_s.exist,
                               backref="job_main_s",
                               cascade="all, delete, delete-orphan")
    rw_constraint_file = True
    links = relation(link_s, backref="job_main_s",
                     primaryjoin=link_s.job_id_source == id,
                     cascade="all, delete, delete-orphan")
    rw_links = False

    def __init__(self, parent, name, type, enabled, has_env,
                 description, x, y, cal_id, start_time, workload_date):
        self.parent = parent
        self.name = convert2unicode(name)
        self.type = type
        self.enabled = enabled
        self.has_env = has_env
        self.description = convert2unicode(description)
        self.x = x
        self.y = y
        self.cal_id = cal_id
        self.start_time = start_time
        self.workload_date = workload_date

    def copy(self):
        j = job_main_s(self.parent, self.name, self.type, self.enabled,
                       self.has_env, self.description, self.x, self.y,
                       self.cal_id, self.start_time, self.workload_date)
        if self.job_start_limit:
            j.job_start_limit = self.job_start_limit.copy()
        else:
            j.job_start_limit = self.job_start_limit
        if self.job_max_duration:
            j.job_max_duration = self.job_max_duration.copy()
        else:
            j.job_max_duration = self.job_max_duration
        if self.job_retries:
            j.job_retries = self.job_retries.copy()
        else:
            j.job_retries = self.job_retries
        if self.job_retries_interval:
            j.job_retries_interval = self.job_retries_interval.copy()
        else:
            j.job_retries_interval = self.job_retries_interval
        if self.job_username:
            j.job_username = self.job_username.copy()
        else:
            j.job_username = self.job_username
        if self.job_file_out:
            j.job_file_out = self.job_file_out.copy()
        else:
            j.job_file_out = self.job_file_out
        if self.job_file_err:
            j.job_file_err = self.job_file_err.copy()
        else:
            j.job_file_err = self.job_file_err
        if self.job_control_group:
            j.job_control_group = self.job_control_group.copy()
        else:
            j.job_control_group = self.job_control_group
        if self.job_loadenv:
            j.job_loadenv = self.job_loadenv.copy()
        else:
            j.job_loadenv = self.job_loadenv
        if self.job_success_return_code:
            j.job_success_return_code = self.job_success_return_code.copy()
        else:
            j.job_success_return_code = self.job_success_return_code
        if self.job_command:
            j.job_command = self.job_command.copy()
        else:
            j.job_command = self.job_command
        j.job_arguments = list()
        for arg in self.job_arguments:
            j.job_arguments.append(arg.copy())
        j.job_environment = list()
        for env in self.job_environment:
            j.job_environment.append(env.copy())
        if self.job_host:
            j.job_host = self.job_host.copy()
        else:
            j.job_host = self.job_host
        j.constraint_file = list()
        for f in self.constraint_file:
            j.constraint_file.append(f.copy())
        j.links = list()
        for link in self.links:
            j.links.append(link.copy())
        return j
