# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKeyConstraint
from sqlalchemy.types import Integer, String

from base import Base, convert2unicode


class job_file_err_s(Base):
    __tablename__ = 'job_file_err_s'
    __table_args__ = (
            ForeignKeyConstraint(['job_id', 'workload_date'],
                                ['job_main_s.id', 'job_main_s.workload_date']),
            {})

    job_id = Column(Integer, primary_key=True)
    file_err = Column(String(255))
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, file_err, workload_date):
        self.file_err = convert2unicode(file_err)
        self.workload_date = workload_date

    def copy(self):
        return job_file_err_s(self.file_err, self.workload_date)
