# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy import Column, Integer, Text, ForeignKey
from sqlalchemy.schema import ForeignKeyConstraint

from base import Base, convert2unicode


class constraint_file_s(Base):
    __tablename__ = 'constraint_file_s'
    __table_args__ = (
            ForeignKeyConstraint(['job_id', 'workload_date'],
                                ['job_main_s.id', 'job_main_s.workload_date']),
            {})

    job_id = Column(Integer, primary_key=True)
    host_id = Column(Integer, ForeignKey('hosts.id'), primary_key=True)
    filename = Column(Text, primary_key=True)
    exist = Column(Integer)
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, host_id, filename, exist, workload_date):
        self.host_id = host_id
        self.filename = convert2unicode(filename)
        self.exist = exist
        self.workload_date = workload_date

    def __eq__(self, other):
        if      self.host_id == other.host_id \
            and self.filename == other.filename \
            and self.workload_date == other.workload_date:
            return True
        return False

    def __ne__(self, other):
        if      self.host_id == other.host_id \
            and self.filename == other.filename \
            and self.workload_date == other.workload_date:
            return False
        return True

    def copy(self):
        return constraint_file_s(self.host_id, self.filename,
                                 self.exist, self.workload_date)
