# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column
from sqlalchemy.types import Integer, Text, String

from base import Base, convert2unicode


class calendars(Base):
    __tablename__ = 'calendars'

    id = Column(Integer, primary_key=True)
    parent = Column(Integer)
    name = Column(String(255))
    entry_type = Column(Integer)    # 0 (calendar) or 1 (folder)
    description = Column(Text)
    formula = Column(Text)

    def __init__(self, parent, name, entry_type, description, formula):
        self.parent = parent
        self.name = convert2unicode(name)
        self.entry_type = entry_type
        self.description = convert2unicode(description)
        self.formula = convert2unicode(formula)

    def copy(self):
        return calendars(self.parent, self.name, self.entry_type,
                         self.description, self.formula)
