# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to create a new environment group."""

import sys
import getopt

import sqlalchemy.exc

import set_options
from tables.environments import environments
from help import print_trim


def usage():
    """Print a usage message on STDOUT."""
    print_trim(_("""Usage: mk [OPTION]... ENV...
        Create new environment groups."""))
    set_options.usage_options(with_name=False)


def mk(sql_session, arguments):
    """Create a new environment group.

    Arguments:
    sql_session -- SQLAlchemy session
    arguments -- list of arguments given to the mk command (list of env groups)

    """
    # Parse the parameters
    try:
        optlist, args = set_options.parse_args(arguments)
    except getopt.GetoptError, err:
        sys.stderr.write(_("mk: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    if not args:
        sys.stderr.write(
                    _("mk: missing the environment group name to create\n"))
        return 1
    session = sql_session.open_session()
    error = False
    for a in args:
        env = environments(a, '')
        session.add(env)
        if set_options.set(session, env, optlist) != 0:
            sql_session.cancel_session(session)
            return 1
    try:
        sql_session.close_session(session)
    except sqlalchemy.exc.IntegrityError:
        sql_session.cancel_session(session)
        sys.stderr.write(
                _("mk: an environment group with this name already exists\n"))
        return 1
    return 0
