/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/** \file
 *  Sample module code.
 *  This is the sample C code of a schedwisrv module.  Such modules can be
 *  used to:
 *  \li Monitor job status (for instance to send an alert to a monitoring
 *      server in case of a job failure)
 *  \li Introduce new constraints to the start of jobs (schedwisrv already
 *      includes start time, file presence and link constraints)
 *
 *  Five entry points (functions) can be called by the schedwisrv module
 *  engine.  None are required: no need to define them if not used.
 *  The 5 functions are:
 *  \li \c schedwi_init which is called once when the module is loaded.
 *  \li \c schedwi_conf which is called during the schedwisrv configuration
 *                      file parsing whenever a parameter for this module
 *                      is detected.
 *  \li \c schedwi_status which is called whenever the status of a job/jobset
 *                      changes.
 *  \li \c schedwi_check which is called to check if the provided job/jobset
 *                      can be started.
 *  \li \c schedwi_exit which is called once just before the module is
 *                      unloaded (usually when the schedwisrv daemon is
 *                      stopped)
 *
 *  One way to compile and install the module is by copying the source file in
 *  the archive src directory and to run the following commands:\n
\verbatim
libtool --mode=compile gcc -I. -I.. -DHAVE_CONFIG_H -Wall -c mod_example.c

libtool --mode=link gcc -g -o mod_example.la \
        -rpath /path/to/install/dir          \
        -no-undefined -module -avoid-version mod_example.lo

libtool --mode=install install -c mod_example.la \
        /path/to/install/dir/mod_example.la
\endverbatim
 *
 *  \author Your Name
 *  \version 0.1.0
 *  \date Fri Aug 31 2007
 */

#include <schedwi.h>
#include <schedwi_jobtree.h>
#include <job_status_state.h>


/** libtool aliases for the exported symbols.  These aliases are used in order
 * to avoid symbol conflicts on some operating systems.  Each symbol
 * (schedwi_init, schedwi_exit, schedwi_conf, schedwi_status and schedwi_check)
 * must be prefixed with "modulename_LTX_" (\c modulename is the name of the
 * module - mod_example here).  You should then replace \c mod_example by
 * your module name in these aliases.
 */
#define schedwi_init mod_example_LTX_schedwi_init
#define schedwi_exit mod_example_LTX_schedwi_exit
#define schedwi_conf mod_example_LTX_schedwi_conf
#define schedwi_status mod_example_LTX_schedwi_status
#define schedwi_check mod_example_LTX_schedwi_check


/** Module initialization function.  This function is called at loading time
 *  and allows the module to initialize its internal data.  It is called only
 *  once, typically when the schedwisrv daemon starts.
 *
 *  \retval 0     The initialization has succeeded.
 *  \retval other The function failed.  schedwisrv will print an error message
 *                and exit.
 */
int
schedwi_init ()
{
	return 0; /* OK */
}


/** Module exit function.  This function is called just before the module is
 *  unload and can be used to free internal data (free memory, close opened
 *  files, ...)
 */
void
schedwi_exit ()
{
	return;
}


/** Module configuration function.  This function is called during the parsing
 *  of the schedwisrv configuration file, for each directive which is intended
 *  to this module.  The format of a such directive is as follow: 
 *  \verbatim MODULE:<module_name>:<key> = <value> \endverbatim
 *  \c module_name is the current module name (without its path and its
 *  extension).  \c key is the parameter name.  \c value is the parameter
 *  value.  See the schedwisrv configuration file (schedwisrv.conf) for
 *  more details.
 *  \warning The schedwisrv daemon reads its configuration file at startup
 *           but also when it receives the HUP signal.  This schedwi_conf
 *           function may therefore be called several times with the same
 *           parameters during the life of the daemon.
 *
 *  \param[in] key   The name of the parameter
 *  \param[in] value The associated value 
 *
 *  \retval 0     The provided parameter has successfully been processed.
 *  \retval other An error occurred.  schedwisrv will print an error message
 *                and exit.
 */
int
schedwi_conf (const char *key, const char *value)
{
	/*
	 * Do something with key and value.  For instance store them in
	 * an internal static array to be used by the schedwi_status() and
	 * schedwi_check() functions
	 */
	return 0; /* OK */
}


/** Job/jobset status change.  Called to signal the change of the status of
 *  a job/jobset.
 *
 *  \param[in] workload  Workload (i.e. YYYYMMDD) of the job/jobset.
 *  \param[in] job       Pointer to the job/jobset object in the tree. 
 *  \param[in] old_state Previous status.
 *  \param[in] new_state Current (new) status.
 *
 *  \retval 0     The function has succeeded.
 *  \retval other An error occurred.  schedwisrv will log an error message.
 */
int
schedwi_status (int workload, const schedwi_jobtree_node_ptr job,
		job_status_state old_state, job_status_state new_state)
{
	switch (new_state) {
		case JOB_STATUS_STATE_WAITING:
		case JOB_STATUS_STATE_RUNNING:
			break;
		case JOB_STATUS_STATE_FAILED:
			/*
			 * Signal a Monitoring Server of this job failure
			 * for instance
			 */
			break;
		case JOB_STATUS_STATE_COMPLETED:
			/*
			 * Signal a Monitoring Server of the success of
			 * this job for instance
			 */
			break;
		default:
			break;
	}
	return 0; /* OK */
}


/** Decide whether the provided job/jobset can start or not.  This function is
 *  called  whenever a job/jobset is ready to be started (i.e. its start time,
 *  constraint links and files are okay) to tell if it can actually start.
 *
 *  \param[in] workload Workload (i.e. YYYYMMDD) of the job/jobset.
 *  \param[in] job      Pointer to the job/jobset object in the tree. 
 *
 *  \retval 0     The job/jobset can start.
 *  \retval 1     The job/jobset cannot start yet (keep it waiting).
 *  \retval other An error occurred.  schedwisrv will log an error message and
 *                the job will not start yet.
 */
int
schedwi_check (int workload, const schedwi_jobtree_node_ptr job)
{
	return 0; /* GO! */
}

/*-----------------============== End Of File ==============-----------------*/
