/* Schedwi
   Copyright (C) 2005 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*
 * startjob_request.h -- Build the string which contains the network request
 *                       to start a job
 */

#ifndef _STARTJOB_REQUEST_H
#define _STARTJOB_REQUEST_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _startjob_request {
	char *req;
	unsigned int idx, size;
};
typedef struct _startjob_request startjob_request;
typedef struct _startjob_request *startjob_request_ptr;


extern startjob_request_ptr startjob_request_new OF(());
extern void startjob_request_destroy OF((startjob_request_ptr ptr));
extern int startjob_request_add_argument OF((startjob_request_ptr ptr,
				const char *pos, unsigned int len_pos,
				const char *val, unsigned int len_val));
extern int startjob_request_add_environment OF((startjob_request_ptr ptr,
					const char *pos,
					const char *key, const char *value));
extern int startjob_request_add_parameter OF((startjob_request_ptr ptr,
					const char *name,
					const char *val,
					unsigned int len_val));
extern int startjob_request_add_jobid OF((startjob_request_ptr ptr,
					const char *workload,
					const char *job_id_str,
					unsigned int len_job_id_str));
extern unsigned int get_request_string OF((startjob_request_ptr ptr,
					const char **req));

#define startjob_request_add_command(X,VAL,LEN) startjob_request_add_parameter(X,"CMD",VAL,LEN)
#define startjob_request_add_username(X,VAL,LEN) startjob_request_add_parameter(X,"USR",VAL,LEN)
#define startjob_request_add_fileout(X,VAL,LEN) startjob_request_add_parameter(X,"OUT",VAL,LEN)
#define startjob_request_add_filerr(X,VAL,LEN) startjob_request_add_parameter(X,"ERR",VAL,LEN)
#define startjob_request_add_loadenv(X,VAL,LEN) startjob_request_add_parameter(X,"LDE",VAL,LEN)
#define startjob_request_add_filename(X,VAL,LEN) startjob_request_add_parameter(X,"FIL",VAL,LEN)


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* startjob_request.h */

/*-----------------============== End Of File ==============-----------------*/
