/* Schedwi
   Copyright (C) 2005 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*
 * sql_get_environment.h -- Get the environment for a job searching its
 *                          ancestors (the job inherit the environments of its
 *                          ancestors).
 */

#ifndef _SQL_GET_ENVIRONMENT_H
#define _SQL_GET_ENVIRONMENT_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int sql_get_environment OF((int workload_date,
	lwc_LL *lst, unsigned int next_pos,
	int (*callback)(void *, unsigned int, const char *, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_get_environment_host OF((int workload_date,
	const char *host_id, 
	int (*callback)(void *, unsigned int, const char *, const char *),
	void *user_data,
	unsigned int *next_pos,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_get_environment.h */

/*-----------------============== End Of File ==============-----------------*/
