/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_commands.h -- commands management functions */

#ifndef _SQL_COMMANDS_H
#define _SQL_COMMANDS_H

#include <schedwi.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int sql_command_get_commands OF((
		int (*callback)(void *, const char *, const char *,
				const char *, int, int),
		void *user_data,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));
extern unsigned int sql_command_add OF((int workload_date, const char *job_id,
					const char *user, int command,
					int parameter, char **err_msg));
extern unsigned int sql_command_done OF((
			int workload_date, const char *job_id,
			int command, int parameter,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_command_failed OF((
			int workload_date, const char *job_id,
			int command, int parameter,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_command_purge OF((char **err_msg));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_commands.h */

/*-----------------============== End Of File ==============-----------------*/
