/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* result_mgnt.c -- Read/write job result status from/to file */

#ifndef _RESULT_MGNT_H
#define _RESULT_MGNT_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif

#if HAVE_STDIO_H
#include <stdio.h>
#endif

#include <lwc_linkedlist.h>

#define ERROR_MSG_LEN 255

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct result_str {
        char *job_id;
	unsigned int job_id_len;
        time_t duration;
	char was_killed;
	int exit_code;
};
typedef struct result_str result_t;

extern result_t *new_result OF(());
extern void destroy_result OF((result_t *r));
extern int result_copy OF((const result_t *src, result_t *dst));
extern int result_to_str OF((result_t *r, char **buffer, size_t *buffer_len));
extern int str_to_results OF((	const char *buffer, size_t buffer_size,
				lwc_LL **list));
extern int write_job_ended_to_file OF((	const char *file_name,
					const char *job_id,
					int exit_code,
					time_t duration));
extern int write_job_killed_to_file OF((const char *file_name,
					const char *job_id,
					int signal,
					time_t duration));

struct file_result {
	result_t *r;
	char *file_name;
};
typedef struct file_result file_result_t;

extern file_result_t *new_file_result_job OF((result_t *r));
extern int new_file_result OF((	const char *directory,
				const char *file_name,
				file_result_t **ret_ptr));
extern void destroy_file_result OF((file_result_t *ret_ptr));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* result_mgnt.h */

/*-----------------============== End Of File ==============-----------------*/
