/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
   USA.
*/

/*
 * net_utils_sock.h -- Useful network functions (basic socket connection
 *                     without SSL)
 */

#ifndef _NET_UTILS_SOCK_H
#define _NET_UTILS_SOCK_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int hostname_cmp OF((const char *h1, const char *h2));
extern short int get_port_number OF((const char *port));
extern int net_server OF((const char *port_number, const char *iface));
extern int build_client_names_from_addr OF((struct in_addr in, char ***names));
extern int build_client_names_from_name OF((	const char *host_name,
						char ***names));
extern void destroy_client_names OF((char **names));
extern int net_client_sock OF((const char *port_number, const char *hostname));
extern ssize_t net_read_sock OF((int sock, char **buff, unsigned int *len));
extern int net_write_sock OF((int sock, const char *buff, size_t len));
extern int net_close_sock OF((int sock));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils_sock.h */

/*-----------------============== End Of File ==============-----------------*/
