/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* load_workload_class.h -- Functions to load and run the workloads */

#ifndef _LOAD_WORKLOAD_CLASS_H
#define _LOAD_WORKLOAD_CLASS_H

#include <schedwi.h>

#include <pthread.h>

#include <lwc_linkedlist.h>
#include <schedwi_time.h>
#include <workload_class.h>

/* Allow the use in C++ code. */
#ifdef __cplusplus
extern "C" {
#endif

struct _load_workload_class {
	lwc_LL *list;
	pthread_mutex_t mutex;
};
typedef struct _load_workload_class load_workload_class;
typedef struct _load_workload_class *load_workload_class_ptr;


extern load_workload_class_ptr load_workload_class_new OF(());
extern void load_workload_class_destroy OF((load_workload_class_ptr ptr));
extern int load_workload_class_from_status_table
					OF((load_workload_class_ptr ptr));
extern int load_workload_class_for_day OF((	load_workload_class_ptr ptr,
						schedwi_date workload_date));
extern workload_class_ptr load_workload_class_find OF((
						load_workload_class_ptr ptr,
						schedwi_date workload_date));
extern void load_workload_class_clean_list OF((	load_workload_class_ptr ptr,
						schedwi_date current_date,
						long int retention_completed,
						long int retention_failed));
extern void load_workload_class_print OF((load_workload_class_ptr ptr));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* load_workload_class.h */

/*-----------------============== End Of File ==============-----------------*/
