/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* job_status_state.c -- Job status definition */

#include <schedwi.h>

#include <job_status_state.h>

/*
 * Convert the provided string to a job_status object
 */
job_status_state
job_status_state_str2status (const char *s)
{
	if (s == NULL) {
		return JOB_STATUS_STATE_UNDEFINED;
	}
	switch (s[0]) {
		case '1':	return JOB_STATUS_STATE_WAITING;
		case '2':	return JOB_STATUS_STATE_RUNNING;
		case '3':	return JOB_STATUS_STATE_COMPLETED;
		case '4':	return JOB_STATUS_STATE_FAILED;
		default:	return JOB_STATUS_STATE_UNDEFINED;
	}
}


/*
 * Convert the provided integer to a job_status object
 */
job_status_state
job_status_state_int2status (int i)
{
	switch (i) {
		case 1:		return JOB_STATUS_STATE_WAITING;
		case 2:		return JOB_STATUS_STATE_RUNNING;
		case 3:		return JOB_STATUS_STATE_COMPLETED;
		case 4:		return JOB_STATUS_STATE_FAILED;
		default:	return JOB_STATUS_STATE_UNDEFINED;
	}
}


/*
 * Convert the provided status to an integer
 */
int
job_status_state_status2int (job_status_state status)
{
	switch (status) {
		case JOB_STATUS_STATE_WAITING:		return 1;
		case JOB_STATUS_STATE_RUNNING:		return 2;
		case JOB_STATUS_STATE_COMPLETED:	return 3;
		case JOB_STATUS_STATE_FAILED:		return 4;
		default:				return 0;
	}
}

/*
 * Convert the provided status to a string (a static string)
 */
char *
job_status_state2str (job_status_state status)
{
	switch (status) {
		case JOB_STATUS_STATE_WAITING:	return _("Waiting");
		case JOB_STATUS_STATE_RUNNING:	return _("Running");
		case JOB_STATUS_STATE_COMPLETED:return _("Completed");
		case JOB_STATUS_STATE_FAILED:	return _("Failed");
		default:			return _("Unknown");
	}
}

/*-----------------============== End Of File ==============-----------------*/
