/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* job_status.h -- Manage the jobs/jobsets status */

#ifndef _JOB_STATUS_H
#define _JOB_STATUS_H

#include <schedwi.h>
#include <schedwi_time.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int job_status_set OF((	unsigned long long int id,
				schedwi_date workload_date,
				job_status_state status,
				unsigned int status_time,
				long int duration,
				const char *error_message));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_status.h */

/*-----------------============== End Of File ==============-----------------*/
