/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* calendar_list.h -- Manage the calendar list */

#ifndef _CALENDAR_LIST_H
#define _CALENDAR_LIST_H

#include <schedwi.h>

#include <calendar.h>
#include <schedwi_time.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

/* A compiled calendar for 3 years */
struct _calendar_t {
	unsigned long long int id;
	cal_t calendar[3];
};
typedef struct _calendar_t calendar_t;
typedef struct _calendar_t *calendar_t_ptr;


/* Calendars list */
struct _calendar_list_t {
	unsigned short int year;
	calendar_t_ptr list;
	unsigned int ncals;
};
typedef struct _calendar_list_t calendar_list_t;
typedef struct _calendar_list_t *calendar_list_t_ptr;


extern calendar_list_t_ptr new_calendar_list OF((schedwi_date workload_date));
extern void destroy_calendar_list OF((calendar_list_t_ptr ptr));
extern int get_calendar_list_for_the_day OF((calendar_list_t_ptr ptr,
					schedwi_date date, char **str));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* calendar_list.h */

/*-----------------============== End Of File ==============-----------------*/
