/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
   USA.
*/

/*
 * send_process.h -- Management functions for the process which is responsible
 *                   for the send of the job results to the server
 */

#ifndef _SEND_PROCESS_H
#define _SEND_PROCESS_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int send_process_start OF(());
extern void send_process_wakeup OF(());
extern void send_process_stop OF(());

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* send_process.h */

/*-----------------============== End Of File ==============-----------------*/
