/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* job_launcher_main.h -- Launcher main function */

#ifndef _JOB_LAUNCHER_MAIN_H
#define _JOB_LAUNCHER_MAIN_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

#if HAVE_PID_T
extern void launcher_main OF((pid_t child, const char *job_id));
#else
extern void launcher_main OF((int child, const char *job_id));
#endif

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_launcher_main.h */

/*-----------------============== End Of File ==============-----------------*/
