/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_test.h -- Test the connection to a Schedwi database */

#ifndef _SQL_TEST_H
#define _SQL_TEST_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

enum sql_test_step {
	SQL_TEST_CONNECT = 0,
	SQL_TEST_DATABASE,
	SQL_TEST_VERSION,

	SQL_TEST_NUM
};
typedef enum sql_test_step sql_test_step_t;

extern int sql_test OF((const char *host, const char *user,
	const char *password, const char *database,
	long int port, const char *socket_file,
	void (*step_status)(sql_test_step_t, char, const char *, void *),
	void *user_data));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_test.h */

/*-----------------============== End Of File ==============-----------------*/
