/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_job.h -- jobs management functions */

#ifndef _SQL_JOB_H
#define _SQL_JOB_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int sql_job_today OF((
		int workload_date,
		lwc_LL **rows,
		const char *parent_id,
		const char *cal_list,
		const char *start_time,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));

extern unsigned int sql_job_tomorrow OF((
		int workload_date,
		lwc_LL **rows,
		const char *parent_id,
		const char *cal_list,
		const char *start_time,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));

extern unsigned int sql_job_get_start_limit OF((
		int workload_date,
		lwc_LL *hierarchy_list,
		short int *start_limit,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));

extern unsigned int sql_job_get_max_duration OF((
		int workload_date,
		lwc_LL *hierarchy_list,
		short int *max_duration,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_job.h */

/*-----------------============== End Of File ==============-----------------*/
